/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.jena;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaIngestUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class JenaIngestUtilsTest
extends AbstractTestClass {
    @Test
    public void testRenameBNodes() {
        JenaIngestUtils jiu = new JenaIngestUtils();
        Model blankModel = ModelFactory.createDefaultModel();
        for (int i = 0; i < 20; ++i) {
            blankModel.add(blankModel.createResource(), RDF.type, (RDFNode)OWL.Thing);
        }
        Assert.assertTrue((blankModel.size() == 20L ? 1 : 0) != 0);
        Model named = jiu.renameBNodes(blankModel, "http://example.org/resource");
        Assert.assertTrue((named.size() == blankModel.size() ? 1 : 0) != 0);
        Assert.assertTrue((named.size() == 20L ? 1 : 0) != 0);
        StmtIterator stmtIt = named.listStatements();
        while (stmtIt.hasNext()) {
            Statement stmt = stmtIt.nextStatement();
            Assert.assertEquals((Object)"http://example.org/", (Object)stmt.getSubject().getNameSpace());
        }
    }
}

