/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringResultsMappingTest
extends AbstractTestClass {
    private static final String SUBJECT_URI_1 = "http://namespace/subject_uri_1";
    private static final String PREDICATE_URI_1 = "http://namespace/predicate_uri_1";
    private static final String OBJECT_VALUE_1 = "object_value_1";
    private static final String SUBJECT_URI_2 = "http://namespace/subject_uri_2";
    private static final String PREDICATE_URI_2 = "http://namespace/predicate_uri_2";
    private static final String OBJECT_VALUE_2 = "object_value_2";
    private static final String SELECT_QUERY = "SELECT ?s ?p ?o WHERE { ?s ?p ?o . }";
    private static final List<Map<String, String>> LIST_ALL_FIELDS = StringResultsMappingTest.list(StringResultsMappingTest.map(StringResultsMappingTest.entry("s", "http://namespace/subject_uri_1"), StringResultsMappingTest.entry("p", "http://namespace/predicate_uri_1"), StringResultsMappingTest.entry("o", "object_value_1")), StringResultsMappingTest.map(StringResultsMappingTest.entry("s", "http://namespace/subject_uri_2"), StringResultsMappingTest.entry("p", "http://namespace/predicate_uri_2"), StringResultsMappingTest.entry("o", "object_value_2")));
    private static final List<Map<String, String>> LIST_ONE_FIELD = StringResultsMappingTest.list(StringResultsMappingTest.map(StringResultsMappingTest.entry("o", "object_value_1")), StringResultsMappingTest.map(StringResultsMappingTest.entry("o", "object_value_2")));
    private static final List<String> FLATTEN_ALL_FIELDS = StringResultsMappingTest.list("http://namespace/subject_uri_1", "http://namespace/predicate_uri_1", "object_value_1", "http://namespace/subject_uri_2", "http://namespace/predicate_uri_2", "object_value_2");
    private static final List<String> FLATTEN_ONE_FIELD = StringResultsMappingTest.list("object_value_1", "object_value_2");
    private Model model;

    @Before
    public void setup() {
        this.model = ModelUtilitiesTestHelper.model(ModelUtilitiesTestHelper.dataProperty(SUBJECT_URI_1, PREDICATE_URI_1, OBJECT_VALUE_1), ModelUtilitiesTestHelper.dataProperty(SUBJECT_URI_2, PREDICATE_URI_2, OBJECT_VALUE_2));
    }

    @Test
    public void checkMapsOfAllFields() {
        this.assertEquivalentUnorderedLists(LIST_ALL_FIELDS, SparqlQueryRunner.createSelectQueryContext((Model)this.model, (String)SELECT_QUERY).execute().toStringFields(new String[0]).getListOfMaps());
    }

    @Test
    public void checkMapsOfOneField() {
        this.assertEquivalentUnorderedLists(LIST_ONE_FIELD, SparqlQueryRunner.createSelectQueryContext((Model)this.model, (String)SELECT_QUERY).execute().toStringFields(new String[]{"o"}).getListOfMaps());
    }

    @Test
    public void checkFlattenAllFields() {
        this.assertEquivalentUnorderedLists(FLATTEN_ALL_FIELDS, SparqlQueryRunner.createSelectQueryContext((Model)this.model, (String)SELECT_QUERY).execute().toStringFields(new String[0]).flatten());
    }

    @Test
    public void checkFlattenOneField() {
        this.assertEquivalentUnorderedLists(FLATTEN_ONE_FIELD, SparqlQueryRunner.createSelectQueryContext((Model)this.model, (String)SELECT_QUERY).execute().toStringFields(new String[]{"o"}).flatten());
    }

    @Test
    public void checkFlattenToSet() {
        Assert.assertEquals(new HashSet<String>(FLATTEN_ONE_FIELD), (Object)SparqlQueryRunner.createSelectQueryContext((Model)this.model, (String)SELECT_QUERY).execute().toStringFields(new String[]{"o"}).flattenToSet());
    }

    private <T> void assertEquivalentUnorderedLists(List<T> list1, List<T> list2) {
        list1.sort(new ArbitraryOrder());
        list2.sort(new ArbitraryOrder());
        Assert.assertEquals(list1, list2);
    }

    @SafeVarargs
    private static <T> List<T> list(T ... items) {
        ArrayList l = new ArrayList();
        Collections.addAll(l, items);
        return l;
    }

    private static Map<String, String> map(Entry ... entries) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (Entry entry : entries) {
            m.put(entry.key, entry.value);
        }
        return m;
    }

    private static Entry entry(String key, String value) {
        return new Entry(key, value);
    }

    private static class Entry {
        final String key;
        final String value;

        Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class ArbitraryOrder<T>
    implements Comparator<T> {
        private ArbitraryOrder() {
        }

        @Override
        public int compare(T t1, T t2) {
            return t1.hashCode() - t2.hashCode();
        }
    }
}

