/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.util;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormUtils {
    protected static final Log log = LogFactory.getLog((String)FormUtils.class.getName());
    protected static final int BASE_10 = 10;
    protected static final Class[] SUPPORTED_TYPES = new Class[]{String.class, Integer.TYPE, Integer.class, Boolean.TYPE, Date.class};
    protected static final List<Class> SUPPORTED_TYPE_LIST = Arrays.asList(SUPPORTED_TYPES);

    public static void populateFormFromBean(Object bean, String action, FormObject foo) {
        FormUtils.populateFormFromBean(bean, action, null, foo, new HashMap<String, String>());
    }

    public static void populateFormFromBean(Object bean, String action, FormObject foo, Map<String, String> badValuesHash) {
        FormUtils.populateFormFromBean(bean, action, null, foo, badValuesHash);
    }

    public static void populateFormFromBean(Object bean, String action, EditProcessObject epo, FormObject foo, Map<String, String> BadValuesHash) {
        Method[] meths;
        Class<?> beanClass = epo != null && epo.getBeanClass() != null ? epo.getBeanClass() : bean.getClass();
        for (Method currMeth : meths = beanClass.getMethods()) {
            Class<?>[] currMethParamTypes;
            Class<?> currMethType;
            if (currMeth.getName().indexOf("set") != 0 || !SUPPORTED_TYPE_LIST.contains(currMethType = (currMethParamTypes = currMeth.getParameterTypes())[0])) continue;
            String elementName = currMeth.getName().substring(3, currMeth.getName().length());
            try {
                String badValue;
                Method getter = beanClass.getMethod("get" + elementName, null);
                Object existingData = null;
                try {
                    existingData = getter.invoke(bean, (Object[])null);
                }
                catch (Exception e) {
                    log.error((Object)"Exception invoking getter method");
                }
                String value = "";
                if (existingData != null) {
                    if (existingData instanceof String) {
                        value = value + existingData;
                    } else if (!(existingData instanceof Integer) || (Integer)existingData >= 0) {
                        value = value + existingData.toString();
                    }
                }
                if ((badValue = BadValuesHash.get(elementName)) != null) {
                    value = badValue;
                }
                foo.getValues().put(elementName, value);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static List<Option> makeOptionListFromBeans(List beanList, String valueField, String bodyField, String selectedValue, String selectedBody) {
        return FormUtils.makeOptionListFromBeans(beanList, valueField, bodyField, selectedValue, selectedBody, true);
    }

    public static List<Option> makeOptionListFromBeans(List beanList, String valueField, String bodyField, String selectedValue, String selectedBody, boolean forceSelectedInclusion) {
        boolean skipThisStep;
        LinkedList<Option> optList = new LinkedList<Option>();
        if (beanList == null) {
            return optList;
        }
        Iterator beanIt = beanList.iterator();
        boolean foundSelectedValueInBeans = false;
        while (beanIt.hasNext()) {
            Object bean = beanIt.next();
            String value = "";
            Method valueMeth = null;
            Object valueObj = null;
            try {
                valueMeth = bean.getClass().getMethod("get" + valueField, null);
                valueObj = valueMeth.invoke(bean, (Object[])null);
            }
            catch (Exception e) {
                log.warn((Object)("Could not find method get" + valueField + " on " + bean.getClass()));
            }
            if (valueObj != null) {
                value = valueObj.toString();
            }
            String body = "";
            Method bodyMeth = null;
            Object bodyObj = null;
            try {
                bodyMeth = bean.getClass().getMethod("get" + bodyField, null);
                bodyObj = bodyMeth.invoke(bean, (Object[])null);
            }
            catch (Exception e) {
                log.warn((Object)(" could not find method get" + bodyField));
            }
            if (bodyObj != null) {
                body = bodyObj.toString();
            }
            Option opt = new Option();
            opt.setValue(value);
            opt.setBody(body);
            if (selectedValue != null) {
                if (selectedValue.equals(value)) {
                    opt.setSelected(true);
                    foundSelectedValueInBeans = true;
                }
            } else if (selectedBody != null && selectedBody.equals(body)) {
                opt.setSelected(true);
                foundSelectedValueInBeans = true;
            }
            optList.add(opt);
        }
        boolean bl = skipThisStep = !forceSelectedInclusion;
        if (selectedValue == null) {
            skipThisStep = true;
        } else {
            try {
                int selectedValueInt = Integer.decode(selectedValue);
                if (selectedValueInt < 0) {
                    skipThisStep = true;
                }
            }
            catch (NumberFormatException selectedValueInt) {
                // empty catch block
            }
        }
        if (!foundSelectedValueInBeans && !skipThisStep) {
            log.trace((Object)"Adding the selected option!");
            Option sOpt = new Option();
            sOpt.setValue(selectedValue);
            if (selectedBody == null || selectedBody.length() == 0) {
                sOpt.setBody(selectedValue);
            } else {
                sOpt.setBody(selectedBody);
            }
            sOpt.setSelected(true);
            optList.add(sOpt);
        }
        return optList;
    }

    public static List<Option> makeVClassOptionList(WebappDaoFactory wadf, String selectedVClassURI) {
        LinkedList<Option> vclassOptionList = new LinkedList<Option>();
        for (VClass vclass : wadf.getVClassDao().getAllVclasses()) {
            Option option = new Option();
            option.setValue(vclass.getURI());
            option.setBody(vclass.getPickListName());
            vclassOptionList.add(option);
            if (selectedVClassURI == null || !selectedVClassURI.equals(vclass.getURI())) continue;
            option.setSelected(true);
        }
        return vclassOptionList;
    }

    public static List<Option> makeOptionListOfSubVClasses(WebappDaoFactory wadf, String parentVClassUri, String selectedVClassURI) {
        VClassDao vClassDao = wadf.getVClassDao();
        HashSet<String> uris = new HashSet<String>(vClassDao.getAllSubClassURIs(parentVClassUri));
        uris.add(parentVClassUri);
        LinkedList<Option> options = new LinkedList<Option>();
        for (String vclassUri : uris) {
            VClass vclass = vClassDao.getVClassByURI(vclassUri);
            Option option = new Option();
            option.setValue(vclass.getURI());
            option.setBody(vclass.getPickListName());
            options.add(option);
            if (!Objects.equals(selectedVClassURI, vclass.getURI())) continue;
            option.setSelected(true);
        }
        options.sort((o1, o2) -> o1.getBody().compareTo(o2.getBody()));
        return options;
    }

    public static void beanSet(Object newObj, String field, String value) {
        FormUtils.beanSet(newObj, field, value, null);
    }

    public static void beanSet(Object newObj, String field, String value, EditProcessObject epo) {
        SimpleDateFormat standardDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat minutesOnlyDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Class<?> cls = epo != null && epo.getBeanClass() != null ? epo.getBeanClass() : newObj.getClass();
        Class[] paramList = new Class[1];
        Method setterMethod = FormUtils.getSetterMethod(cls, field, SUPPORTED_TYPE_LIST);
        if (setterMethod == null) {
            log.debug((Object)("Could not find method set" + field + " on " + cls.getName()));
            return;
        }
        Class<?> argumentType = setterMethod.getParameterTypes()[0];
        Object[] arglist = new Object[1];
        if (Integer.TYPE.equals(argumentType) || Integer.class.equals(argumentType)) {
            Object object = arglist[0] = Integer.TYPE.equals(argumentType) ? Integer.valueOf(-1) : null;
            if (!value.isEmpty()) {
                int parsedInt = Integer.parseInt(value, 10);
                if (parsedInt < 0) {
                    throw new NegativeIntegerException();
                }
                arglist[0] = parsedInt;
            }
        } else if (Date.class.equals(argumentType)) {
            if (value != null && value.length() > 0 && value.indexOf(":") < 1) {
                value = value + " 00:00:00";
            }
            if (value != null && value.length() > 0) {
                try {
                    arglist[0] = standardDateFormat.parse(value);
                }
                catch (ParseException p) {
                    try {
                        arglist[0] = minutesOnlyDateFormat.parse(value);
                    }
                    catch (ParseException q) {
                        log.error((Object)(FormUtils.class.getName() + " could not parse" + value + " to a Date object."));
                        throw new IllegalArgumentException("Please enter a date/time in one of these formats: '2007-07-07', '2007-07-07 07:07' or '2007-07-07 07:07:07'");
                    }
                }
            } else {
                arglist[0] = null;
            }
        } else {
            arglist[0] = Boolean.TYPE.equals(argumentType) ? Boolean.valueOf(value.equalsIgnoreCase("true")) : value;
        }
        try {
            setterMethod.invoke(newObj, arglist);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private static Method getSetterMethod(Class beanClass, String fieldName, List<Class> supportedTypes) {
        for (Class clazz : supportedTypes) {
            try {
                Class[] argList = new Class[]{clazz};
                return beanClass.getMethod("set" + fieldName, argList);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    public static Map<String, String> beanParamMapFromString(String params) {
        String[] param = params.split(";");
        HashMap<String, String> beanParamMap = new HashMap<String, String>();
        for (String aParam : param) {
            String[] p = aParam.split(":");
            beanParamMap.put(p[0], new String(Base64.decodeBase64((byte[])p[1].getBytes())));
            if (p.length <= 3) continue;
            beanParamMap.put(p[2], new String(Base64.decodeBase64((byte[])p[3].getBytes())));
        }
        return beanParamMap;
    }

    public static class NegativeIntegerException
    extends RuntimeException {
    }
}

