/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier.factory;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasPermission;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.BaseUserBasedIdentifierBundleFactory;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.Permission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.PermissionRegistry;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HasPermissionFactory
extends BaseUserBasedIdentifierBundleFactory {
    private static final Log log = LogFactory.getLog(HasPermissionFactory.class);

    public HasPermissionFactory(ServletContext ctx) {
        super(ctx);
    }

    @Override
    public IdentifierBundle getIdentifierBundleForUser(UserAccount user) {
        if (user == null) {
            return this.createPublicPermissions();
        }
        return this.createUserPermissions(user);
    }

    private IdentifierBundle createPublicPermissions() {
        HashSet<String> permissionUris = new HashSet<String>();
        for (PermissionSet ps : this.uaDao.getAllPermissionSets()) {
            if (!ps.isForPublic()) continue;
            permissionUris.addAll(ps.getPermissionUris());
        }
        log.debug((Object)("Permission URIs: " + permissionUris));
        return new ArrayIdentifierBundle((Collection<? extends Identifier>)this.getIdentifiersFromPermissions(this.getPermissionsForUris(permissionUris)));
    }

    private IdentifierBundle createUserPermissions(UserAccount user) {
        HashSet<String> permissionUris = new HashSet<String>();
        for (String psUri : user.getPermissionSetUris()) {
            PermissionSet ps = this.uaDao.getPermissionSetByUri(psUri);
            if (ps == null) continue;
            permissionUris.addAll(ps.getPermissionUris());
        }
        log.debug((Object)("user permission sets: " + user.getPermissionSetUris()));
        log.debug((Object)("Permission URIs: " + permissionUris));
        return new ArrayIdentifierBundle((Collection<? extends Identifier>)this.getIdentifiersFromPermissions(this.getPermissionsForUris(permissionUris)));
    }

    private Collection<Permission> getPermissionsForUris(Collection<String> permissionUris) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        PermissionRegistry registry = PermissionRegistry.getRegistry(this.ctx);
        for (String uri : permissionUris) {
            permissions.add(registry.getPermission(uri));
        }
        return permissions;
    }

    private List<HasPermission> getIdentifiersFromPermissions(Collection<Permission> permissions) {
        ArrayList<HasPermission> ids = new ArrayList<HasPermission>();
        for (Permission permission : permissions) {
            ids.add(new HasPermission(permission));
        }
        return ids;
    }
}

