/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier.factory;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasProfile;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.IsBlacklisted;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.BaseUserBasedIdentifierBundleFactory;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HasProfileOrIsBlacklistedFactory
extends BaseUserBasedIdentifierBundleFactory {
    private static final Log log = LogFactory.getLog(HasProfileOrIsBlacklistedFactory.class);

    public HasProfileOrIsBlacklistedFactory(ServletContext ctx) {
        super(ctx);
    }

    @Override
    public IdentifierBundle getIdentifierBundleForUser(UserAccount user) {
        ArrayIdentifierBundle ids = new ArrayIdentifierBundle(new Identifier[0]);
        for (Individual ind : this.getAssociatedIndividuals(user)) {
            IsBlacklisted id = IsBlacklisted.getInstance(ind, this.ctx);
            if (id != null) {
                ids.add(id);
                continue;
            }
            ids.add(new HasProfile(ind.getURI()));
        }
        return ids;
    }

    private Collection<Individual> getAssociatedIndividuals(UserAccount user) {
        ArrayList<Individual> individuals = new ArrayList<Individual>();
        if (user == null) {
            log.debug((Object)"No Associated Individuals: not logged in.");
            return individuals;
        }
        SelfEditingConfiguration sec = SelfEditingConfiguration.getBean(this.ctx);
        individuals.addAll(sec.getAssociatedIndividuals(this.indDao, user));
        return individuals;
    }
}

