/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.beans.ResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class BaseResourceBean
implements ResourceBean {
    private static final Log log = LogFactory.getLog((String)BaseResourceBean.class.getName());
    protected String URI = null;
    protected String namespace = null;
    protected String localName = null;
    protected String localNameWithPrefix = null;
    protected String pickListName = null;
    protected RoleLevel hiddenFromDisplayBelowRoleLevel = null;
    protected RoleLevel prohibitedFromUpdateBelowRoleLevel = null;
    protected RoleLevel hiddenFromPublishBelowRoleLevel = null;

    public BaseResourceBean() {
    }

    public BaseResourceBean(String uri) {
        this.buildLocalAndNS(uri);
    }

    @Override
    public boolean isAnonymous() {
        return this.URI == null || "http://vitro.mannlib.cornell.edu/ns/bnode#".equals(this.getNamespace());
    }

    @Override
    public String getURI() {
        return this.URI;
    }

    @Override
    public void setURI(String URI2) {
        if (this.localName != null || this.namespace != null) {
            this.buildLocalAndNS(URI2);
        } else {
            this.URI = URI2;
        }
    }

    private void buildLocalAndNS(String URI2) {
        if (URI2 == null) {
            this.URI = null;
            this.namespace = null;
            this.localName = null;
        } else {
            this.URI = URI2;
            Resource uri = ResourceFactory.createResource((String)URI2);
            this.namespace = uri.getNameSpace();
            this.localName = uri.getLocalName();
        }
    }

    @Override
    public String getNamespace() {
        if (this.namespace == null && this.URI != null) {
            this.buildLocalAndNS(this.URI);
        }
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null && this.localName != null) {
            this.URI = namespace + this.localName;
        }
    }

    @Override
    public String getLabel() {
        return this.getLocalName();
    }

    @Override
    public String getLocalName() {
        if (this.localName == null && this.URI != null) {
            this.buildLocalAndNS(this.URI);
        }
        return this.localName;
    }

    @Override
    public void setLocalName(String localName) {
        this.localName = localName;
        if (this.namespace != null && localName != null) {
            this.URI = this.namespace + localName;
        }
    }

    public String getLocalNameWithPrefix() {
        return this.localNameWithPrefix != null ? this.localNameWithPrefix : (this.getLocalName() != null ? this.getLocalName() : (this.URI != null ? this.URI : "(no name)"));
    }

    public void setLocalNameWithPrefix(String prefixedLocalName) {
        this.localNameWithPrefix = prefixedLocalName;
    }

    @Override
    public String getPickListName() {
        return this.pickListName == null ? (this.getLocalName() == null ? (this.URI == null ? "(no name)" : this.URI) : this.getLocalName()) : this.pickListName;
    }

    public void setPickListName(String pickListName) {
        this.pickListName = pickListName;
    }

    @Override
    public RoleLevel getHiddenFromDisplayBelowRoleLevel() {
        return this.hiddenFromDisplayBelowRoleLevel;
    }

    @Override
    public void setHiddenFromDisplayBelowRoleLevel(RoleLevel level) {
        this.hiddenFromDisplayBelowRoleLevel = level;
    }

    @Override
    public void setHiddenFromDisplayBelowRoleLevelUsingRoleUri(String roleUri) {
        this.hiddenFromDisplayBelowRoleLevel = RoleLevel.getRoleByUri(roleUri);
    }

    @Override
    public RoleLevel getProhibitedFromUpdateBelowRoleLevel() {
        return this.prohibitedFromUpdateBelowRoleLevel;
    }

    @Override
    public void setProhibitedFromUpdateBelowRoleLevel(RoleLevel level) {
        this.prohibitedFromUpdateBelowRoleLevel = level;
    }

    @Override
    public void setProhibitedFromUpdateBelowRoleLevelUsingRoleUri(String roleUri) {
        this.prohibitedFromUpdateBelowRoleLevel = RoleLevel.getRoleByUri(roleUri);
    }

    @Override
    public RoleLevel getHiddenFromPublishBelowRoleLevel() {
        return this.hiddenFromPublishBelowRoleLevel;
    }

    @Override
    public void setHiddenFromPublishBelowRoleLevel(RoleLevel level) {
        this.hiddenFromPublishBelowRoleLevel = level;
    }

    @Override
    public void setHiddenFromPublishBelowRoleLevelUsingRoleUri(String roleUri) {
        this.hiddenFromPublishBelowRoleLevel = RoleLevel.getRoleByUri(roleUri);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof BaseResourceBean) {
            String thisURI = this.getURI();
            String thatURI = ((BaseResourceBean)obj).getURI();
            if (thisURI != null && thatURI != null) {
                return thisURI.equals(thatURI);
            }
        }
        return obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.getURI() != null) {
            return this.getURI().hashCode();
        }
        return super.hashCode();
    }

    public static enum RoleLevel {
        PUBLIC("http://vitro.mannlib.cornell.edu/ns/vitro/role#public", "all users, including public", "all users who can log in", "public"),
        SELF("http://vitro.mannlib.cornell.edu/ns/vitro/role#selfEditor", "self-editor and above", "self-editor and above", "self"),
        EDITOR("http://vitro.mannlib.cornell.edu/ns/vitro/role#editor", "editor and above", "editor and above", "editor"),
        CURATOR("http://vitro.mannlib.cornell.edu/ns/vitro/role#curator", "curator and above", "curator and above", "curator"),
        DB_ADMIN("http://vitro.mannlib.cornell.edu/ns/vitro/role#dbAdmin", "site admin and root user", "site admin and root user", "siteAdmin"),
        NOBODY("http://vitro.mannlib.cornell.edu/ns/vitro/role#nobody", "root user", "root user", "root");

        private final String uri;
        private final String displayLabel;
        private final String updateLabel;
        private final String shorthand;

        private RoleLevel(String uri, String displayLabel, String updateLabel, String shorthand) {
            this.uri = uri;
            this.displayLabel = displayLabel;
            this.updateLabel = updateLabel;
            this.shorthand = shorthand;
        }

        public String getURI() {
            return this.uri;
        }

        public String getDisplayLabel() {
            return this.displayLabel;
        }

        public String getUpdateLabel() {
            return this.updateLabel;
        }

        public String getShorthand() {
            return this.shorthand;
        }

        public static RoleLevel getRoleByUri(String uri2) {
            if (uri2 == null) {
                return RoleLevel.values()[0];
            }
            for (RoleLevel role : RoleLevel.values()) {
                if (!role.uri.equals(uri2)) continue;
                return role;
            }
            return RoleLevel.values()[0];
        }

        public static RoleLevel getRoleFromLoginStatus(HttpServletRequest req) {
            UserAccount u = LoginStatusBean.getCurrentUser(req);
            if (u == null) {
                return PUBLIC;
            }
            Set<String> roles = u.getPermissionSetUris();
            if (roles.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN")) {
                return DB_ADMIN;
            }
            if (roles.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR")) {
                return CURATOR;
            }
            if (roles.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR")) {
                return EDITOR;
            }
            if (roles.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR")) {
                return SELF;
            }
            return SELF;
        }
    }
}

