/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;

public class UserAccount {
    public static final int MIN_PASSWORD_LENGTH = 6;
    public static final int MAX_PASSWORD_LENGTH = 12;
    private String uri = "";
    private String emailAddress = "";
    private String firstName = "";
    private String lastName = "";
    private String argon2Password = "";
    private String md5Password = "";
    private String oldPassword = "";
    private long passwordLinkExpires = 0L;
    private String emailKey = "";
    private boolean passwordChangeRequired = false;
    private int loginCount = 0;
    private long lastLoginTime = 0L;
    private Status status = Status.INACTIVE;
    private String externalAuthId = "";
    private boolean externalAuthOnly = false;
    private Set<String> permissionSetUris = Collections.emptySet();
    private boolean rootUser = false;
    private Set<String> proxiedIndividualUris = Collections.emptySet();

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        if (uri == null) {
            throw new NullPointerException("uri may not be null.");
        }
        this.uri = uri;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = this.nonNull(emailAddress, "");
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = this.nonNull(firstName, "");
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = this.nonNull(lastName, "");
    }

    public String getArgon2Password() {
        return this.argon2Password;
    }

    public void setArgon2Password(String argo2Password) {
        this.argon2Password = this.nonNull(argo2Password, "");
    }

    public String getMd5Password() {
        return this.md5Password;
    }

    public void setMd5Password(String md5Password) {
        this.md5Password = this.nonNull(md5Password, "");
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = this.nonNull(oldPassword, "");
    }

    public long getPasswordLinkExpires() {
        return this.passwordLinkExpires;
    }

    public void setPasswordLinkExpires(long passwordLinkExpires) {
        this.passwordLinkExpires = Math.max(0L, passwordLinkExpires);
    }

    public void generateEmailKey() {
        boolean useLetters = true;
        boolean useNumbers = true;
        int length = 64;
        this.emailKey = RandomStringUtils.random((int)length, (boolean)useLetters, (boolean)useNumbers);
    }

    public void setEmailKey(String emailKey) {
        if (emailKey != null) {
            this.emailKey = emailKey;
        }
    }

    public String getEmailKey() {
        return this.emailKey;
    }

    public boolean isPasswordChangeRequired() {
        return this.passwordChangeRequired;
    }

    public void setPasswordChangeRequired(Boolean passwordChangeRequired) {
        this.passwordChangeRequired = this.nonNull(passwordChangeRequired, Boolean.FALSE);
    }

    public boolean isExternalAuthOnly() {
        return this.externalAuthOnly;
    }

    public void setExternalAuthOnly(Boolean externalAuthOnly) {
        this.externalAuthOnly = this.nonNull(externalAuthOnly, Boolean.FALSE);
    }

    public int getLoginCount() {
        return this.loginCount;
    }

    public void setLoginCount(int loginCount) {
        this.loginCount = Math.max(0, loginCount);
    }

    public long getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(long lastLoginTime) {
        this.lastLoginTime = Math.max(0L, lastLoginTime);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStatusFromString(String statusString) {
        this.status = Status.fromString(statusString);
    }

    public String getExternalAuthId() {
        return this.externalAuthId;
    }

    public void setExternalAuthId(String externalAuthId) {
        this.externalAuthId = this.nonNull(externalAuthId, "");
    }

    public Set<String> getPermissionSetUris() {
        return new HashSet<String>(this.permissionSetUris);
    }

    public void setPermissionSetUris(Collection<String> permissionSetUris) {
        if (permissionSetUris == null) {
            throw new NullPointerException("permissionSetUris may not be null.");
        }
        this.permissionSetUris = new HashSet<String>(permissionSetUris);
    }

    public boolean isRootUser() {
        return this.rootUser;
    }

    public void setRootUser(boolean rootUser) {
        this.rootUser = rootUser;
    }

    public Set<String> getProxiedIndividualUris() {
        return new HashSet<String>(this.proxiedIndividualUris);
    }

    public void setProxiedIndividualUris(Collection<String> proxiedIndividualUris) {
        if (proxiedIndividualUris == null) {
            throw new NullPointerException("proxiedIndividualUris may not be null.");
        }
        this.proxiedIndividualUris = new HashSet<String>(proxiedIndividualUris);
    }

    private <T> T nonNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    private String limitStringLength(int limit, String s) {
        if (s == null) {
            return "";
        }
        if (s.length() <= limit) {
            return s;
        }
        return s.substring(0, limit);
    }

    public String toString() {
        return "UserAccount[uri=" + this.uri + ", emailAddress=" + this.emailAddress + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", md5password=" + this.md5Password + ", oldPassword=" + this.oldPassword + ", argon2password=" + this.argon2Password + ", passwordLinkExpires=" + this.passwordLinkExpires + ", emailKey =" + this.emailKey + ", passwordChangeRequired=" + this.passwordChangeRequired + ", externalAuthOnly=" + this.externalAuthOnly + ", loginCount=" + this.loginCount + ", status=" + (Object)((Object)this.status) + ", lastLoginTime=" + this.lastLoginTime + ", externalAuthId=" + this.externalAuthId + ", rootUser=" + this.rootUser + ", permissionSetUris=" + this.permissionSetUris + "]";
    }

    public static enum Status {
        ACTIVE,
        INACTIVE;


        public static Status fromString(String s) {
            if (s == null) {
                return null;
            }
            for (Status status : Status.values()) {
                if (!status.toString().equals(s)) continue;
                return status;
            }
            return null;
        }
    }
}

