/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.admin;

import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsAddPageStrategy;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsProfileCreator;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserAccountsAddPage
extends UserAccountsPage {
    private static final Log log = LogFactory.getLog(UserAccountsAddPage.class);
    private static final String PARAMETER_SUBMIT = "submitAdd";
    private static final String PARAMETER_EMAIL_ADDRESS = "emailAddress";
    private static final String PARAMETER_EXTERNAL_AUTH_ID = "externalAuthId";
    private static final String PARAMETER_EXTERNAL_AUTH_ONLY = "externalAuthOnly";
    private static final String PARAMETER_FIRST_NAME = "firstName";
    private static final String PARAMETER_LAST_NAME = "lastName";
    private static final String PARAMETER_ROLE = "role";
    private static final String PARAMETER_ASSOCIATED_PROFILE_URI = "associatedProfileUri";
    private static final String PARAMETER_NEW_PROFILE_CLASS_URI = "newProfileClassUri";
    private static final String ERROR_NO_EMAIL = "errorEmailIsEmpty";
    private static final String ERROR_EMAIL_IN_USE = "errorEmailInUse";
    private static final String ERROR_EMAIL_INVALID_FORMAT = "errorEmailInvalidFormat";
    private static final String ERROR_EXTERNAL_AUTH_ID_IN_USE = "errorExternalAuthIdInUse";
    private static final String ERROR_NO_FIRST_NAME = "errorFirstNameIsEmpty";
    private static final String ERROR_NO_LAST_NAME = "errorLastNameIsEmpty";
    private static final String ERROR_NO_ROLE = "errorNoRoleSelected";
    private static final String TEMPLATE_NAME = "userAccounts-add.ftl";
    private final UserAccountsAddPageStrategy strategy;
    private final boolean matchingIsEnabled;
    private boolean submit;
    private String emailAddress = "";
    private String externalAuthId = "";
    private boolean externalAuthOnly;
    private String firstName = "";
    private String lastName = "";
    private Collection<String> selectedRoleUris = Collections.emptyList();
    private String associatedProfileUri = "";
    private String newProfileClassUri = "";
    private String errorCode = "";
    private UserAccount addedAccount;

    public UserAccountsAddPage(VitroRequest vreq) {
        super(vreq);
        this.strategy = UserAccountsAddPageStrategy.getInstance(vreq, this, this.isEmailEnabled());
        this.matchingIsEnabled = SelfEditingConfiguration.getBean((ServletRequest)vreq).isConfigured();
        this.parseRequestParameters();
        if (this.submit) {
            this.validateParameters();
        }
    }

    private void parseRequestParameters() {
        this.submit = this.isFlagOnRequest(PARAMETER_SUBMIT);
        this.emailAddress = this.getStringParameter(PARAMETER_EMAIL_ADDRESS, "");
        this.externalAuthId = this.getStringParameter(PARAMETER_EXTERNAL_AUTH_ID, "");
        this.externalAuthOnly = this.isFlagOnRequest(PARAMETER_EXTERNAL_AUTH_ONLY);
        this.firstName = this.getStringParameter(PARAMETER_FIRST_NAME, "");
        this.lastName = this.getStringParameter(PARAMETER_LAST_NAME, "");
        this.selectedRoleUris = this.getStringParameters(PARAMETER_ROLE);
        this.associatedProfileUri = this.getStringParameter(PARAMETER_ASSOCIATED_PROFILE_URI, "");
        this.newProfileClassUri = this.getStringParameter(PARAMETER_NEW_PROFILE_CLASS_URI, "");
        this.strategy.parseAdditionalParameters();
    }

    public boolean isSubmit() {
        return this.submit;
    }

    private void validateParameters() {
        this.errorCode = this.emailAddress.isEmpty() ? ERROR_NO_EMAIL : (this.isEmailInUse() ? ERROR_EMAIL_IN_USE : (!this.isEmailValidFormat() ? ERROR_EMAIL_INVALID_FORMAT : (this.isExternalAuthIdInUse() ? ERROR_EXTERNAL_AUTH_ID_IN_USE : (this.firstName.isEmpty() ? ERROR_NO_FIRST_NAME : (this.lastName.isEmpty() ? ERROR_NO_LAST_NAME : (this.selectedRoleUris.isEmpty() ? ERROR_NO_ROLE : this.strategy.additionalValidations()))))));
    }

    private boolean isEmailInUse() {
        return this.userAccountsDao.getUserAccountByEmail(this.emailAddress) != null;
    }

    private boolean isExternalAuthIdInUse() {
        if (this.externalAuthId.isEmpty()) {
            return false;
        }
        return this.userAccountsDao.getUserAccountByExternalAuthId(this.externalAuthId) != null;
    }

    private boolean isEmailValidFormat() {
        return Authenticator.isValidEmailAddress(this.emailAddress);
    }

    public boolean isValid() {
        return this.errorCode.isEmpty();
    }

    public void createNewAccount() {
        UserAccount u = new UserAccount();
        u.setEmailAddress(this.emailAddress);
        u.setFirstName(this.firstName);
        u.setLastName(this.lastName);
        u.setExternalAuthId(this.externalAuthId);
        u.setExternalAuthOnly(this.externalAuthOnly);
        u.setMd5Password("");
        u.setOldPassword("");
        u.setPasswordChangeRequired(false);
        u.setPasswordLinkExpires(0L);
        u.setEmailKey("");
        u.setLoginCount(0);
        u.setLastLoginTime(0L);
        u.setStatus(UserAccount.Status.INACTIVE);
        u.setPermissionSetUris(this.selectedRoleUris);
        this.strategy.setAdditionalProperties(u);
        String uri = this.userAccountsDao.insertUserAccount(u);
        this.addedAccount = this.userAccountsDao.getUserAccountByUri(uri);
        if (this.matchingIsEnabled) {
            if (!this.newProfileClassUri.isEmpty()) {
                try {
                    String newProfileUri;
                    this.associatedProfileUri = newProfileUri = UserAccountsProfileCreator.createProfile(this.indDao, this.dpsDao, this.newProfileClassUri, this.addedAccount);
                }
                catch (InsertException e) {
                    log.error((Object)("Failed to create new profile of class '" + this.newProfileClassUri + "' for user '" + this.addedAccount.getEmailAddress() + "'"));
                }
            }
            SelfEditingConfiguration.getBean((ServletRequest)this.vreq).associateIndividualWithUserAccount(this.indDao, this.dpsDao, this.addedAccount, this.associatedProfileUri);
        }
        this.strategy.notifyUser();
    }

    public final ResponseValues showPage() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.isSubmit()) {
            body.put(PARAMETER_EMAIL_ADDRESS, this.emailAddress);
            body.put(PARAMETER_EXTERNAL_AUTH_ID, this.externalAuthId);
            body.put(PARAMETER_FIRST_NAME, this.firstName);
            body.put(PARAMETER_LAST_NAME, this.lastName);
            body.put("selectedRoles", this.selectedRoleUris);
        } else {
            body.put(PARAMETER_EMAIL_ADDRESS, "");
            body.put(PARAMETER_EXTERNAL_AUTH_ID, "");
            body.put(PARAMETER_FIRST_NAME, "");
            body.put(PARAMETER_LAST_NAME, "");
            body.put("selectedRoles", this.getDefaultRolesForNewUsers());
        }
        body.put("roles", this.buildListOfSelectableRoles());
        body.put("profileTypes", this.buildProfileTypesList());
        body.put(PARAMETER_NEW_PROFILE_CLASS_URI, this.newProfileClassUri);
        body.put("formUrls", this.buildUrlsMap());
        if (this.externalAuthOnly) {
            body.put(PARAMETER_EXTERNAL_AUTH_ONLY, Boolean.TRUE);
        }
        if (!this.associatedProfileUri.isEmpty()) {
            body.put("associatedProfileInfo", this.buildProfileInfo(this.associatedProfileUri));
        }
        if (!this.errorCode.isEmpty()) {
            body.put(this.errorCode, Boolean.TRUE);
        }
        if (this.matchingIsEnabled) {
            body.put("showAssociation", Boolean.TRUE);
        }
        this.strategy.addMoreBodyValues(body);
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private Collection<String> getDefaultRolesForNewUsers() {
        ArrayList<String> list = new ArrayList<String>();
        for (PermissionSet ps : this.userAccountsDao.getAllPermissionSets()) {
            if (!ps.isForNewUsers()) continue;
            list.add(ps.getUri());
        }
        return list;
    }

    public UserAccount getAddedAccount() {
        return this.addedAccount;
    }

    public boolean wasPasswordEmailSent() {
        return this.strategy.wasPasswordEmailSent();
    }

    boolean isExternalAuthOnly() {
        return this.externalAuthOnly;
    }
}

