/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.AbstractPageHandler;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ManageProxiesCreatePage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ManageProxiesEditPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ManageProxiesListPage;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import java.util.Map;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="ManageProxies", urlPatterns={"/manageProxies/*"})
public class ManageProxiesController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(ManageProxiesController.class);
    private static final String ACTION_CREATE = "/create";
    private static final String ACTION_EDIT = "/edit";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.MANAGE_PROXIES.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        if (log.isDebugEnabled()) {
            this.dumpRequestParameters((HttpServletRequest)vreq);
        }
        String action = vreq.getPathInfo();
        log.debug((Object)("action = '" + action + "'"));
        if (ACTION_CREATE.equals(action)) {
            return this.handleCreateRequest(vreq);
        }
        if (ACTION_EDIT.equals(action)) {
            return this.handleEditRequest(vreq);
        }
        return this.handleListRequest(vreq);
    }

    private ResponseValues handleCreateRequest(VitroRequest vreq) {
        ManageProxiesCreatePage page = new ManageProxiesCreatePage(vreq);
        if (page.isValid()) {
            page.createRelationships();
            AbstractPageHandler.Message.setMessage((HttpServletRequest)vreq, new SuccessMessage());
        } else {
            AbstractPageHandler.Message.setMessage((HttpServletRequest)vreq, new FailureMessage());
        }
        return this.redirectToList();
    }

    private ResponseValues handleEditRequest(VitroRequest vreq) {
        ManageProxiesEditPage page = new ManageProxiesEditPage(vreq);
        if (page.isValid()) {
            page.applyEdits();
            AbstractPageHandler.Message.setMessage((HttpServletRequest)vreq, new SuccessMessage());
        } else {
            AbstractPageHandler.Message.setMessage((HttpServletRequest)vreq, new FailureMessage());
        }
        return this.redirectToList();
    }

    private ResponseValues handleListRequest(VitroRequest vreq) {
        ManageProxiesListPage page = new ManageProxiesListPage(vreq);
        return page.showPage();
    }

    private ResponseValues redirectToList() {
        return new RedirectResponseValues("/manageProxies/list");
    }

    private static class FailureMessage
    extends AbstractPageHandler.Message {
        private FailureMessage() {
        }

        @Override
        public Map<String, Object> getMessageInfoMap() {
            return this.assembleMap("failure", Boolean.TRUE);
        }
    }

    private static class SuccessMessage
    extends AbstractPageHandler.Message {
        private SuccessMessage() {
        }

        @Override
        public Map<String, Object> getMessageInfoMap() {
            return this.assembleMap("success", Boolean.TRUE);
        }
    }
}

