/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.AbstractPageHandler;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyItemInfo;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationship;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelection;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelectionCriteria;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelector;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.web.images.PlaceholderUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManageProxiesListPage
extends AbstractPageHandler {
    private static final Log log = LogFactory.getLog(ManageProxiesListPage.class);
    public static final String PARAMETER_RELATIONSHIPS_PER_PAGE = "relationshipsPerPage";
    public static final String PARAMETER_PAGE_INDEX = "pageIndex";
    public static final String PARAMETER_VIEW_TYPE = "viewType";
    public static final String PARAMETER_SEARCH_TERM = "searchTerm";
    private static final String TEMPLATE_NAME = "manageProxies-list.ftl";
    private final ProxyRelationshipSelector.Context selectorContext;
    private ProxyRelationshipSelectionCriteria criteria = ProxyRelationshipSelectionCriteria.DEFAULT_CRITERIA;

    public ManageProxiesListPage(VitroRequest vreq) {
        super(vreq);
        this.selectorContext = new ProxyRelationshipSelector.Context(this.userAccountsModel, this.unionModel, this.getMatchingProperty());
        this.parseParameters();
    }

    private String getMatchingProperty() {
        return ConfigurationProperties.getBean((ServletRequest)this.vreq).getProperty("selfEditing.idMatchingProperty", "");
    }

    private void parseParameters() {
        int relationshipsPerPage = this.getIntegerParameter(PARAMETER_RELATIONSHIPS_PER_PAGE, 20);
        int pageIndex = this.getIntegerParameter(PARAMETER_PAGE_INDEX, 1);
        ProxyRelationshipSelectionCriteria.ProxyRelationshipView viewType = ProxyRelationshipSelectionCriteria.ProxyRelationshipView.fromKeyword(this.vreq.getParameter(PARAMETER_VIEW_TYPE));
        String searchTerm = this.getStringParameter(PARAMETER_SEARCH_TERM, "");
        this.criteria = new ProxyRelationshipSelectionCriteria(relationshipsPerPage, pageIndex, viewType, searchTerm);
        log.debug((Object)("selection criteria is: " + this.criteria));
    }

    public ResponseValues showPage() {
        ProxyRelationshipSelection selection = ProxyRelationshipSelector.select(this.selectorContext, this.criteria);
        log.debug((Object)("Selection: " + selection));
        Map<String, Object> body = this.buildTemplateBodyMap(selection);
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private Map<String, Object> buildTemplateBodyMap(ProxyRelationshipSelection selection) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put(PARAMETER_RELATIONSHIPS_PER_PAGE, this.criteria.getRelationshipsPerPage());
        body.put(PARAMETER_PAGE_INDEX, this.criteria.getPageIndex());
        body.put(PARAMETER_VIEW_TYPE, (Object)this.criteria.getViewBy());
        body.put(PARAMETER_SEARCH_TERM, this.criteria.getSearchTerm());
        body.put("relationships", this.wrapProxyRelationships(selection));
        body.put("total", selection.getTotalResultCount());
        body.put("page", this.buildPageMap(selection));
        body.put("formUrls", this.buildUrlsMap());
        this.applyMessage((HttpServletRequest)this.vreq, body);
        log.debug((Object)("body map is: " + body));
        return body;
    }

    private List<ProxyRelationship> wrapProxyRelationships(ProxyRelationshipSelection selection) {
        ArrayList<ProxyRelationship> wrapped = new ArrayList<ProxyRelationship>();
        for (ProxyRelationship r : selection.getProxyRelationships()) {
            wrapped.add(new ProxyRelationship(this.wrapProxyItemList(r.getProxyInfos()), this.wrapProfileItemList(r.getProfileInfos())));
        }
        return wrapped;
    }

    private List<ProxyItemInfo> wrapProxyItemList(List<ProxyItemInfo> items) {
        ArrayList<ProxyItemInfo> wrapped = new ArrayList<ProxyItemInfo>();
        for (ProxyItemInfo item : items) {
            wrapped.add(this.wrapProxyItem(item));
        }
        return wrapped;
    }

    private List<ProxyItemInfo> wrapProfileItemList(List<ProxyItemInfo> items) {
        ArrayList<ProxyItemInfo> wrapped = new ArrayList<ProxyItemInfo>();
        for (ProxyItemInfo item : items) {
            wrapped.add(this.wrapProfileItem(item));
        }
        return wrapped;
    }

    private ProxyItemInfo wrapProxyItem(ProxyItemInfo item) {
        String imagePath = item.getImageUrl();
        if (imagePath.isEmpty()) {
            imagePath = PlaceholderUtil.getPlaceholderImagePathForType(this.vreq, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#UserAccount");
        }
        UserAccount ua = this.userAccountsDao.getUserAccountByUri(item.getUri());
        List<Individual> profiles = SelfEditingConfiguration.getBean((ServletRequest)this.vreq).getAssociatedIndividuals(this.indDao, ua);
        String profileUri = profiles.isEmpty() ? "" : profiles.get(0).getURI();
        return new ProxyItemWrapper(item.getUri(), item.getLabel(), item.getClassLabel(), UrlBuilder.getUrl(imagePath), profileUri);
    }

    private ProxyItemInfo wrapProfileItem(ProxyItemInfo item) {
        String imagePath = item.getImageUrl();
        if (imagePath.isEmpty()) {
            imagePath = PlaceholderUtil.getPlaceholderImagePathForIndividual(this.vreq, item.getUri());
        }
        return new ProfileItemWrapper(item.getUri(), item.getLabel(), item.getClassLabel(), UrlBuilder.getUrl(imagePath));
    }

    private Map<String, Integer> buildPageMap(ProxyRelationshipSelection selection) {
        int currentPage = selection.getCriteria().getPageIndex();
        float pageCount = (float)selection.getTotalResultCount() / (float)selection.getCriteria().getRelationshipsPerPage();
        int lastPage = (int)Math.ceil(pageCount);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("current", currentPage);
        map.put("first", 1);
        map.put("last", lastPage);
        if (currentPage < lastPage) {
            map.put("next", currentPage + 1);
        }
        if (currentPage > 1) {
            map.put("previous", currentPage - 1);
        }
        return map;
    }

    protected Map<String, String> buildUrlsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("list", UrlBuilder.getUrl("/manageProxies/list"));
        map.put("edit", UrlBuilder.getUrl("/manageProxies/edit"));
        map.put("create", UrlBuilder.getUrl("/manageProxies/create"));
        map.put("ajax", UrlBuilder.getUrl("/proxiesAjax"));
        return map;
    }

    private static class ProfileItemWrapper
    extends ProxyItemInfo {
        public ProfileItemWrapper(String uri, String label, String classLabel, String imageUrl) {
            super(uri, label, classLabel, imageUrl);
        }
    }

    public static class ProxyItemWrapper
    extends ProxyItemInfo {
        private final String profileUri;

        public ProxyItemWrapper(String uri, String label, String classLabel, String imageUrl, String profileUri) {
            super(uri, label, classLabel, imageUrl);
            this.profileUri = profileUri;
        }

        public String getProfileUri() {
            return this.profileUri;
        }

        @Override
        public String toString() {
            return "ProxyItemWrapper[uri=" + this.getUri() + ", label=" + this.getLabel() + ", classLabel=" + this.getClassLabel() + ", imageUrl=" + this.getImageUrl() + ", profileUri=" + this.profileUri + "]";
        }
    }
}

