/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.ajax;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.freemarker.config.FreemarkerConfiguration;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class VitroAjaxController
extends HttpServlet {
    private static final Log log = LogFactory.getLog(VitroAjaxController.class);

    protected abstract void doRequest(VitroRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        VitroRequest vreq = new VitroRequest(req);
        if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, new AuthorizationRequest[]{this.requiredActions(vreq)})) {
            this.doRequest(vreq, resp);
        } else {
            resp.sendError(403, "Not authorized");
        }
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return AuthorizationRequest.AUTHORIZED;
    }

    protected void writeTemplate(String templateName, Map<String, Object> map, HttpServletRequest req, HttpServletResponse response) {
        Configuration config = FreemarkerConfiguration.getConfig(req);
        try {
            Template template = config.getTemplate(templateName);
            PrintWriter out = response.getWriter();
            template.process(map, (Writer)out);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected void doError(HttpServletResponse response, String errorMsg, int httpstatus) {
        response.setStatus(httpstatus);
        try {
            response.getWriter().write(errorMsg);
        }
        catch (IOException e) {
            log.debug((Object)"IO exception during output", (Throwable)e);
        }
    }
}

