/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery;

import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.ResultSetMediaType;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiResultSetProducer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SparqlQueryApiAskExecutor
extends SparqlQueryApiResultSetProducer {
    public SparqlQueryApiAskExecutor(RDFService rdfService, String queryString, String acceptHeader) throws AcceptHeaderParsingException, NotAcceptableException {
        super(rdfService, queryString, acceptHeader);
    }

    @Override
    protected InputStream getRawResultStream() throws RDFServiceException {
        boolean queryResult = this.rdfService.sparqlAskQuery(this.queryString);
        String resultString = this.mediaType == ResultSetMediaType.XML ? String.format("<?xml version=\"1.0\"?>\n<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\">\n  <head></head>\n  <boolean>%b</boolean>\n</sparql>", queryResult) : (this.mediaType == ResultSetMediaType.JSON ? String.format("{\n  \"head\" : { } ,\n  \"boolean\" : %b\n}\n", queryResult) : String.valueOf(queryResult));
        return new ByteArrayInputStream(resultString.getBytes());
    }
}

