/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalAuthHelper {
    private static final Log log = LogFactory.getLog(ExternalAuthHelper.class);
    private static final ExternalAuthHelper DUMMY_HELPER = new ExternalAuthHelper(null, null);
    private static final String BEAN_ATTRIBUTE = ExternalAuthHelper.class.getName();
    private static final String PROPERTY_EXTERNAL_AUTH_SERVER_URL = "externalAuth.serverUrl";
    public static final String PROPERTY_EXTERNAL_AUTH_ID_HEADER = "externalAuth.netIdHeaderName";
    private final String externalAuthServerUrl;
    private final String externalAuthHeaderName;

    public static ExternalAuthHelper getHelper(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            log.trace((Object)("Not an HttpServletRequest: " + request));
            return DUMMY_HELPER;
        }
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        if (session == null) {
            log.trace((Object)"No session; no need to create one.");
            return DUMMY_HELPER;
        }
        ServletContext ctx = session.getServletContext();
        Object attr = ctx.getAttribute(BEAN_ATTRIBUTE);
        if (attr instanceof ExternalAuthHelper) {
            log.trace((Object)("Found a bean: " + attr));
            return (ExternalAuthHelper)attr;
        }
        ExternalAuthHelper bean = ExternalAuthHelper.buildBean(ctx);
        log.debug((Object)("Created a bean: " + bean));
        ExternalAuthHelper.setBean(ctx, bean);
        return bean;
    }

    protected static void setBean(ServletContext context, ExternalAuthHelper bean) {
        context.setAttribute(BEAN_ATTRIBUTE, (Object)bean);
    }

    private static ExternalAuthHelper buildBean(ServletContext ctx) {
        String externalAuthServerUrl = ConfigurationProperties.getBean(ctx).getProperty(PROPERTY_EXTERNAL_AUTH_SERVER_URL);
        String externalAuthHeaderName = ConfigurationProperties.getBean(ctx).getProperty(PROPERTY_EXTERNAL_AUTH_ID_HEADER);
        return new ExternalAuthHelper(externalAuthServerUrl, externalAuthHeaderName);
    }

    protected ExternalAuthHelper(String externalAuthServerUrl, String externalAuthHeaderName) {
        this.externalAuthServerUrl = this.trimThis(externalAuthServerUrl);
        this.externalAuthHeaderName = this.trimThis(externalAuthHeaderName);
    }

    private String trimThis(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public String buildExternalAuthRedirectUrl(String returnUrl) {
        if (returnUrl == null) {
            log.error((Object)"returnUrl is null.");
            return null;
        }
        if (this.externalAuthServerUrl == null) {
            log.debug((Object)("runtime.properties doesn't contain a value for 'externalAuth.serverUrl' -- sending directly to '" + returnUrl + "'"));
            return returnUrl;
        }
        try {
            String encodedReturnUrl = URLEncoder.encode(returnUrl, "UTF-8");
            String externalAuthUrl = this.externalAuthServerUrl + "?target=" + encodedReturnUrl;
            log.debug((Object)("externalAuthUrl is '" + externalAuthUrl + "'"));
            return externalAuthUrl;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getExternalAuthId(HttpServletRequest request) {
        if (request == null) {
            log.error((Object)"request is null.");
            return null;
        }
        if (this.externalAuthHeaderName == null) {
            log.error((Object)"User asked for external authentication, but runtime.properties doesn't contain a value for 'externalAuth.netIdHeaderName'");
            return null;
        }
        String externalAuthId = request.getHeader(this.externalAuthHeaderName);
        log.debug((Object)("externalAuthId=" + externalAuthId));
        return externalAuthId;
    }

    public String toString() {
        return "ExternalAuthHelper[externalAuthServerUrl=" + this.externalAuthServerUrl + ", externalAuthHeaderName=" + this.externalAuthHeaderName + "]";
    }
}

