/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.utils;

import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalNamespaceClassUtils {
    private static final Log log = LogFactory.getLog((String)LocalNamespaceClassUtils.class.getName());

    public static HashMap<String, String> getLocalNamespacesClasses(VitroRequest vreq, HashMap<String, String> namespaces) {
        HashMap<String, String> localClasses = new HashMap<String, String>();
        List<VClass> allClasses = vreq.getWebappDaoFactory().getVClassDao().getAllVclasses();
        for (VClass v : allClasses) {
            String classNamespace = v.getNamespace();
            String classUri = v.getURI();
            if (!namespaces.containsKey(classNamespace)) continue;
            String namespaceLabel = namespaces.get(classNamespace);
            String prefix = namespaceLabel.substring(namespaceLabel.indexOf("(") + 1, namespaceLabel.indexOf(")"));
            localClasses.put(classUri, v.getName() + " ( " + prefix + ")");
        }
        return localClasses;
    }

    private static HashMap<String, String> convertToHash(List<String> namespaces) {
        HashMap<String, String> namespaceHash = new HashMap<String, String>();
        for (String n : namespaces) {
            namespaceHash.put(n, "true");
        }
        return namespaceHash;
    }

    public static HashMap<String, String> getLocalOntologyNamespaces(VitroRequest vreq) {
        HashMap<String, String> foundNamespaces = new HashMap<String, String>();
        String defaultNamespacePattern = LocalNamespaceClassUtils.getDefaultOntologyNamespace(vreq);
        if (defaultNamespacePattern != null) {
            OntologyDao dao = vreq.getUnfilteredWebappDaoFactory().getOntologyDao();
            List<Ontology> onts = dao.getAllOntologies();
            for (Ontology on : onts) {
                String uri = on.getURI();
                if (!uri.startsWith(defaultNamespacePattern)) continue;
                String name = on.getName();
                String prefix = on.getPrefix();
                foundNamespaces.put(uri, name + " (" + prefix + ")");
            }
        }
        return foundNamespaces;
    }

    public static String getDefaultOntologyNamespace(VitroRequest vreq) {
        String defaultNamespace = vreq.getWebappDaoFactory().getDefaultNamespace();
        int lastIndex = defaultNamespace.lastIndexOf("/individual");
        if (lastIndex != -1) {
            defaultNamespace = defaultNamespace.substring(0, lastIndex) + "/ontology/";
            return defaultNamespace;
        }
        log.error((Object)("Default namespace " + defaultNamespace + " should have /individual, returning null for default namespace"));
        return null;
    }
}

