/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;

@WebServlet(name="HomePageController", urlPatterns={"/home"})
public class HomePageController
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(HomePageController.class);
    private static final String PAGE_TEMPLATE = "page-home.ftl";
    private static final String BODY_TEMPLATE = "home.ftl";

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        HashMap<String, Object> body = new HashMap<String, Object>();
        List<DataGetter> dgList = DataGetterUtils.getDataGettersForPage(vreq, (Model)vreq.getDisplayModel(), "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#Home");
        for (DataGetter dg : dgList) {
            Map<String, Object> moreData = dg.getData(body);
            if (moreData == null) continue;
            body.putAll(moreData);
        }
        body.put("dataServiceUrlVClassesForVClassGroup", UrlBuilder.getUrl("/dataservice?getVClassesForVClassGroup=1&classgroupUri="));
        body.put("geoFocusMapsEnabled", this.getGeoFocusMapsFlag(vreq));
        return new TemplateResponseValues(BODY_TEMPLATE, body);
    }

    @Override
    protected String getTitle(String siteName, VitroRequest vreq) {
        return siteName;
    }

    @Override
    protected String getPageTemplateName() {
        return PAGE_TEMPLATE;
    }

    private boolean getGeoFocusMapsFlag(VitroRequest vreq) {
        String property = ConfigurationProperties.getBean((ServletRequest)vreq).getProperty("homePage.geoFocusMaps");
        return "enabled".equals(property);
    }
}

