/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.FauxPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.annotation.WebServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="ListFauxPropertiesController", urlPatterns={"/listFauxProperties"})
public class ListFauxPropertiesController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ListFauxPropertiesController.class.getName());
    private static final String TEMPLATE_NAME = "siteAdmin-fauxPropertiesList.ftl";
    private ObjectPropertyDao opDao = null;
    private PropertyGroupDao pgDao = null;
    private FauxPropertyDao fpDao = null;
    private String notFoundMessage = "";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.EDIT_ONTOLOGY.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        try {
            String displayOption = "";
            displayOption = vreq.getParameter("displayOption") != null ? vreq.getParameter("displayOption") : "listing";
            body.put("displayOption", displayOption);
            if (displayOption.equals("listing")) {
                body.put("pageTitle", "Faux Property Listing");
            } else {
                body.put("pageTitle", "Faux Properties by Base Property");
            }
            this.opDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getObjectPropertyDao();
            this.fpDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getFauxPropertyDao();
            this.pgDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getPropertyGroupDao();
            List<ObjectProperty> objectProps = null;
            objectProps = this.opDao.getRootObjectProperties();
            TreeMap<Object, Object> allFauxProps = new TreeMap();
            allFauxProps = displayOption.equals("listing") ? this.getFauxPropertyList(objectProps) : this.getFauxByBaseList(objectProps);
            log.debug((Object)((Object)allFauxProps).toString());
            if (this.notFoundMessage.length() == 0) {
                body.put("message", this.notFoundMessage);
            } else {
                body.put("fauxProps", allFauxProps);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private TreeMap<String, Object> getFauxPropertyList(List<ObjectProperty> objectProps) {
        List<FauxProperty> fauxProps = null;
        TreeMap<String, Object> theFauxProps = new TreeMap<String, Object>();
        if (objectProps != null) {
            Iterator<ObjectProperty> opIt = objectProps.iterator();
            if (!opIt.hasNext()) {
                this.notFoundMessage = "No object properties found.";
            } else {
                while (opIt.hasNext()) {
                    ObjectProperty op = opIt.next();
                    String baseURI = op.getURI();
                    fauxProps = this.fpDao.getFauxPropertiesForBaseUri(baseURI);
                    if (fauxProps == null) continue;
                    Iterator<FauxProperty> fpIt = fauxProps.iterator();
                    if (!fpIt.hasNext()) {
                        this.notFoundMessage = "No faux properties found.";
                        continue;
                    }
                    while (fpIt.hasNext()) {
                        String baseLabel = ListFauxPropertiesController.getDisplayLabel(op) == null ? "(no name)" : ListFauxPropertiesController.getDisplayLabel(op);
                        String baseLocalName = op.getLocalNameWithPrefix();
                        baseLabel = baseLabel.substring(0, baseLabel.indexOf("("));
                        baseLabel = baseLabel + "(" + baseLocalName + ")";
                        FauxProperty fp = fpIt.next();
                        String fauxLabel = fp.getDisplayName();
                        String rangeLabel = fp.getRangeLabel();
                        String rangeURI = fp.getRangeURI();
                        String domainLabel = fp.getDomainLabel();
                        String domainURI = fp.getDomainURI();
                        String groupURI = fp.getGroupURI();
                        PropertyGroup pGroup = this.pgDao.getGroupByURI(groupURI);
                        String groupLabel = pGroup == null ? "unspecified" : pGroup.getName();
                        HashMap<String, String> tmpHash = new HashMap<String, String>();
                        tmpHash.put("base", baseLabel);
                        tmpHash.put("baseURI", baseURI);
                        tmpHash.put("group", groupLabel);
                        tmpHash.put("range", rangeLabel);
                        tmpHash.put("rangeURI", rangeURI);
                        tmpHash.put("domain", domainLabel);
                        tmpHash.put("domainURI", domainURI);
                        theFauxProps.put(fauxLabel + "@@" + domainLabel, tmpHash);
                    }
                }
            }
        }
        return theFauxProps;
    }

    private TreeMap<String, Object> getFauxByBaseList(List<ObjectProperty> objectProps) {
        List<FauxProperty> fauxProps = null;
        TreeMap<String, Object> fauxByBaseProps = new TreeMap<String, Object>();
        if (objectProps != null) {
            Iterator<ObjectProperty> opIt = objectProps.iterator();
            if (!opIt.hasNext()) {
                this.notFoundMessage = "No object properties found.";
            } else {
                while (opIt.hasNext()) {
                    TreeMap fauxForGivenBase = new TreeMap();
                    ObjectProperty op = opIt.next();
                    String baseURI = op.getURI();
                    fauxProps = this.fpDao.getFauxPropertiesForBaseUri(baseURI);
                    if (fauxProps == null) continue;
                    Iterator<FauxProperty> fpIt = fauxProps.iterator();
                    if (!fpIt.hasNext()) {
                        this.notFoundMessage = "No faux properties found.";
                        continue;
                    }
                    String baseLabel = ListFauxPropertiesController.getDisplayLabel(op) == null ? "(no name)" : ListFauxPropertiesController.getDisplayLabel(op);
                    String baseLocalName = op.getLocalNameWithPrefix();
                    baseLabel = baseLabel.substring(0, baseLabel.indexOf("("));
                    baseLabel = baseLabel + "(" + baseLocalName + ")|" + baseURI;
                    while (fpIt.hasNext()) {
                        FauxProperty fp = fpIt.next();
                        String fauxLabel = fp.getDisplayName();
                        String rangeLabel = fp.getRangeLabel();
                        String rangeURI = fp.getRangeURI();
                        String domainLabel = fp.getDomainLabel();
                        String domainURI = fp.getDomainURI();
                        String groupURI = fp.getGroupURI();
                        PropertyGroup pGroup = this.pgDao.getGroupByURI(groupURI);
                        String groupLabel = pGroup == null ? "unspecified" : pGroup.getName();
                        HashMap<String, String> tmpHash = new HashMap<String, String>();
                        tmpHash.put("baseURI", baseURI);
                        tmpHash.put("group", groupLabel);
                        tmpHash.put("range", rangeLabel);
                        tmpHash.put("rangeURI", rangeURI);
                        tmpHash.put("domain", domainLabel);
                        tmpHash.put("domainURI", domainURI);
                        fauxForGivenBase.put(fauxLabel + "@@" + domainLabel, tmpHash);
                    }
                    fauxByBaseProps.put(baseLabel, fauxForGivenBase);
                }
            }
        }
        return fauxByBaseProps;
    }

    public static String getDisplayLabel(ObjectProperty op) {
        String displayLabel = op.getPickListName();
        displayLabel = displayLabel != null && displayLabel.length() > 0 ? displayLabel : op.getLocalName();
        return displayLabel != null ? displayLabel : "[object property]";
    }
}

