/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.DataPropertyStatementFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.LinkedList;
import java.util.List;
import net.sf.jga.algorithms.Filter;

public class DataPropertyFiltering
extends DataProperty {
    private VitroFilters filters;
    private DataProperty innerDataProperty;

    public DataPropertyFiltering(DataProperty innerDataProperty, VitroFilters filters) {
        this.innerDataProperty = innerDataProperty;
        this.filters = filters;
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements() {
        List<DataPropertyStatement> propStmts = this.innerDataProperty.getDataPropertyStatements();
        if (propStmts == null) {
            return null;
        }
        LinkedList filteredStmts = new LinkedList();
        Filter.filter(propStmts, this.filters.getDataPropertyStatementFilter(), filteredStmts);
        LinkedList<DataPropertyStatement> wrappedStmts = new LinkedList<DataPropertyStatement>();
        for (DataPropertyStatement stmt : filteredStmts) {
            wrappedStmts.add(new DataPropertyStatementFiltering(stmt, this.filters));
        }
        return wrappedStmts;
    }

    @Override
    public int compareTo(DataProperty op) {
        return this.innerDataProperty.compareTo(op);
    }

    @Override
    public boolean equals(Object obj) {
        return this.innerDataProperty.equals(obj);
    }

    @Override
    public String getDescription() {
        return this.innerDataProperty.getDescription();
    }

    @Override
    public int getDisplayLimit() {
        return this.innerDataProperty.getDisplayLimit();
    }

    @Override
    public int getDisplayTier() {
        return this.innerDataProperty.getDisplayTier();
    }

    @Override
    public String getDomainClassURI() {
        return this.innerDataProperty.getDomainClassURI();
    }

    @Override
    public String getPublicName() {
        return this.innerDataProperty.getPublicName();
    }

    @Override
    public String getLabel() {
        return this.innerDataProperty.getLabel();
    }

    @Override
    public String getExample() {
        return this.innerDataProperty.getExample();
    }

    @Override
    public String getGroupURI() {
        return this.innerDataProperty.getGroupURI();
    }

    @Override
    public BaseResourceBean.RoleLevel getHiddenFromDisplayBelowRoleLevel() {
        return this.innerDataProperty.getHiddenFromDisplayBelowRoleLevel();
    }

    @Override
    public BaseResourceBean.RoleLevel getProhibitedFromUpdateBelowRoleLevel() {
        return this.innerDataProperty.getProhibitedFromUpdateBelowRoleLevel();
    }

    @Override
    public BaseResourceBean.RoleLevel getHiddenFromPublishBelowRoleLevel() {
        return this.innerDataProperty.getHiddenFromPublishBelowRoleLevel();
    }

    @Override
    public String getLocalName() {
        return this.innerDataProperty.getLocalName();
    }

    @Override
    public String getLocalNameWithPrefix() {
        return this.innerDataProperty.getLocalNameWithPrefix();
    }

    @Override
    public String getPickListName() {
        return this.innerDataProperty.getPickListName();
    }

    @Override
    public String getNamespace() {
        return this.innerDataProperty.getNamespace();
    }

    @Override
    public String getPublicDescription() {
        return this.innerDataProperty.getPublicDescription();
    }

    @Override
    public String getURI() {
        return this.innerDataProperty.getURI();
    }

    @Override
    public int hashCode() {
        return this.innerDataProperty.hashCode();
    }

    @Override
    public boolean isAnonymous() {
        return this.innerDataProperty.isAnonymous();
    }

    @Override
    public boolean isSubjectSide() {
        return this.innerDataProperty.isSubjectSide();
    }

    @Override
    public void setDescription(String description) {
        this.innerDataProperty.setDescription(description);
    }

    @Override
    public void setPublicName(String publicName) {
        this.innerDataProperty.setPublicName(publicName);
    }

    @Override
    public void setDomainClassURI(String domainClassURI) {
        this.innerDataProperty.setDomainClassURI(domainClassURI);
    }

    @Override
    public void setLabel(String label) {
        this.innerDataProperty.setLabel(label);
    }

    @Override
    public void setExample(String example) {
        this.innerDataProperty.setExample(example);
    }

    @Override
    public void setGroupURI(String in) {
        this.innerDataProperty.setGroupURI(in);
    }

    @Override
    public void setHiddenFromDisplayBelowRoleLevel(BaseResourceBean.RoleLevel eR) {
        this.innerDataProperty.setHiddenFromDisplayBelowRoleLevel(eR);
    }

    @Override
    public void setHiddenFromDisplayBelowRoleLevelUsingRoleUri(String roleUri) {
        this.innerDataProperty.setHiddenFromDisplayBelowRoleLevel(BaseResourceBean.RoleLevel.getRoleByUri(roleUri));
    }

    @Override
    public void setProhibitedFromUpdateBelowRoleLevel(BaseResourceBean.RoleLevel eR) {
        this.innerDataProperty.setProhibitedFromUpdateBelowRoleLevel(eR);
    }

    @Override
    public void setProhibitedFromUpdateBelowRoleLevelUsingRoleUri(String roleUri) {
        this.innerDataProperty.setProhibitedFromUpdateBelowRoleLevel(BaseResourceBean.RoleLevel.getRoleByUri(roleUri));
    }

    @Override
    public void setHiddenFromPublishBelowRoleLevel(BaseResourceBean.RoleLevel eR) {
        this.innerDataProperty.setHiddenFromPublishBelowRoleLevel(eR);
    }

    @Override
    public void setHiddenFromPublishBelowRoleLevelUsingRoleUri(String roleUri) {
        this.innerDataProperty.setHiddenFromPublishBelowRoleLevel(BaseResourceBean.RoleLevel.getRoleByUri(roleUri));
    }

    @Override
    public void setLocalName(String localName) {
        this.innerDataProperty.setLocalName(localName);
    }

    @Override
    public void setLocalNameWithPrefix(String localNameWithPrefix) {
        this.innerDataProperty.setLocalNameWithPrefix(localNameWithPrefix);
    }

    @Override
    public void setPickListName(String pickListName) {
        this.innerDataProperty.setPickListName(pickListName);
    }

    @Override
    public void setNamespace(String namespace) {
        this.innerDataProperty.setNamespace(namespace);
    }

    @Override
    public void setDataPropertyStatements(List<DataPropertyStatement> objectPropertyStatements) {
        this.innerDataProperty.setDataPropertyStatements(objectPropertyStatements);
    }

    @Override
    public void setPublicDescription(String s) {
        this.innerDataProperty.setPublicDescription(s);
    }

    @Override
    public void setDisplayLimit(int displayLimit) {
        this.innerDataProperty.setDisplayLimit(displayLimit);
    }

    @Override
    public void setDisplayTier(int displayTier) {
        this.innerDataProperty.setDisplayTier(displayTier);
    }

    @Override
    public void setURI(String URI2) {
        this.innerDataProperty.setURI(URI2);
    }

    @Override
    public String toString() {
        return this.innerDataProperty.toString();
    }
}

