/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class EditSubmissionUtils {
    protected static final String MULTI_VALUED_EDIT_SUBMISSION = "MultiValueEditSubmission";

    public static MultiValueEditSubmission getEditSubmissionFromSession(HttpSession sess, EditConfigurationVTwo editConfig) {
        Map submissions = (Map)sess.getAttribute(MULTI_VALUED_EDIT_SUBMISSION);
        if (submissions == null) {
            return null;
        }
        if (editConfig != null) {
            return (MultiValueEditSubmission)submissions.get(editConfig.getEditKey());
        }
        return null;
    }

    public static void putEditSubmissionInSession(HttpSession sess, MultiValueEditSubmission editSub) {
        HashMap<String, MultiValueEditSubmission> submissions = (HashMap<String, MultiValueEditSubmission>)sess.getAttribute(MULTI_VALUED_EDIT_SUBMISSION);
        if (submissions == null) {
            submissions = new HashMap<String, MultiValueEditSubmission>();
            sess.setAttribute(MULTI_VALUED_EDIT_SUBMISSION, submissions);
        }
        submissions.put(editSub.editKey, editSub);
    }

    public static void clearEditSubmissionInSession(HttpSession sess, MultiValueEditSubmission editSub) {
        if (sess == null) {
            return;
        }
        if (editSub == null) {
            return;
        }
        Map submissions = (Map)sess.getAttribute(MULTI_VALUED_EDIT_SUBMISSION);
        if (submissions == null) {
            throw new Error("MultiValueEditSubmission: could not get a Map of MultiValueEditSubmission from the session.");
        }
        submissions.remove(editSub.editKey);
    }

    public static void clearAllEditSubmissionsInSession(HttpSession sess) {
        if (sess == null) {
            return;
        }
        sess.removeAttribute(MULTI_VALUED_EDIT_SUBMISSION);
    }

    public static Map<String, String[]> convertParams(Map<String, List<String>> queryParameters) {
        HashMap<String, String[]> out = new HashMap<String, String[]>();
        for (String key : queryParameters.keySet()) {
            List<String> item = queryParameters.get(key);
            out.put(key, item.toArray(new String[item.size()]));
        }
        return out;
    }
}

