/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.vocabulary.OWL;

public class ChildVClassesWithParent
implements FieldOptions {
    private static final String LEFT_BLANK = "";
    String fieldName;
    String classUri;
    String defaultOptionLabel = null;

    public ChildVClassesWithParent(String classUri) throws Exception {
        if (classUri == null || classUri.equals(LEFT_BLANK)) {
            throw new Exception("vclassUri not set");
        }
        this.classUri = classUri;
    }

    public ChildVClassesWithParent setDefaultOption(String label) {
        this.defaultOptionLabel = label;
        return this;
    }

    @Override
    public Map<String, String> getOptions(EditConfigurationVTwo editConfig, String fieldName, WebappDaoFactory wDaoFact, I18nBundle i18n) throws Exception {
        LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)this.defaultOptionLabel)) {
            optionsMap.put(LEFT_BLANK, this.defaultOptionLabel);
        }
        String other_i18n = i18n.text("other", new Object[0]);
        optionsMap.put(this.classUri, other_i18n.substring(0, 1).toUpperCase() + other_i18n.substring(1));
        VClassDao vclassDao = wDaoFact.getVClassDao();
        List<String> subClassList = vclassDao.getAllSubClassURIs(this.classUri);
        if (subClassList != null && subClassList.size() > 0) {
            for (String subClassUri : subClassList) {
                VClass subClass = vclassDao.getVClassByURI(subClassUri);
                if (subClass == null || OWL.Nothing.getURI().equals(subClassUri)) continue;
                optionsMap.put(subClassUri, subClass.getName().trim());
            }
        }
        return optionsMap;
    }

    @Override
    public Comparator<String[]> getCustomComparator() {
        return null;
    }
}

