/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConstantFieldOptions
implements FieldOptions {
    List<List<String>> options;

    public ConstantFieldOptions(String ... optionPairs) throws Exception {
        if (optionPairs == null) {
            throw new Exception("Must specify option pairs in ConstantFieldOptions constructor");
        }
        if (optionPairs.length % 2 != 0) {
            throw new Exception("options must be in pairs of (value,lable)");
        }
        this.options = new ArrayList<List<String>>(optionPairs.length / 2);
        for (int i = 0; i < optionPairs.length; i += 2) {
            ArrayList<String> pair = new ArrayList<String>(2);
            pair.add(optionPairs[i]);
            pair.add(optionPairs[i + 1]);
            this.options.add(pair);
        }
    }

    public ConstantFieldOptions(String fieldName2, List<List<String>> optionPairs) throws Exception {
        for (List<String> literalPair : optionPairs) {
            if (literalPair == null) {
                throw new Exception("no items in optionPairs may be null.");
            }
            if (literalPair.size() == 0) {
                throw new Exception("no items in optionPairs  may be empty lists.");
            }
            if (literalPair.size() <= 2) continue;
            throw new Exception("no items in optionPairs  may be lists longer than 2 items.");
        }
        this.options = optionPairs;
    }

    @Override
    public Map<String, String> getOptions(EditConfigurationVTwo editConfig, String fieldName, WebappDaoFactory wDaoFact, I18nBundle i18n) throws Exception {
        LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        for (Object t : this.options) {
            List literalPair = (List)t;
            String value = (String)literalPair.get(0);
            if (value == null) continue;
            String label = (String)literalPair.get(1);
            if (label != null) {
                optionsMap.put(value, label);
                continue;
            }
            optionsMap.put(value, value);
        }
        return optionsMap;
    }

    @Override
    public Comparator<String[]> getCustomComparator() {
        return null;
    }
}

