/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultObjectPropertyFormGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDeleteGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    private static final Log log = LogFactory.getLog(DefaultObjectPropertyFormGenerator.class);
    private static final String PROPERTY_TEMPLATE = "confirmDeletePropertyForm.ftl";
    private static final String INDIVIDUAL_TEMPLATE = "confirmDeleteIndividualForm.ftl";
    private String subjectUri = null;
    private String predicateUri = null;
    private String objectUri = null;
    private Integer dataHash = 0;
    private DataPropertyStatement dps = null;

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = EditConfigurationVTwo.getConfigFromSession(session, (HttpServletRequest)vreq);
        if (editConfiguration == null) {
            editConfiguration = this.setupEditConfiguration(vreq, session);
        }
        this.prepare(vreq, editConfiguration);
        if (editConfiguration.getPredicateUri() == null && editConfiguration.getSubjectUri() == null) {
            editConfiguration.setTemplate(INDIVIDUAL_TEMPLATE);
            this.addDeleteParams(vreq, editConfiguration);
        } else {
            editConfiguration.setTemplate(PROPERTY_TEMPLATE);
        }
        return editConfiguration;
    }

    private void addDeleteParams(VitroRequest vreq, EditConfigurationVTwo editConfiguration) {
        String redirectUrl = vreq.getParameter("redirectUrl");
        if (redirectUrl != null) {
            editConfiguration.addFormSpecificData("redirectUrl", redirectUrl);
        }
        String individualName = vreq.getParameter("individualName");
        if (redirectUrl != null) {
            editConfiguration.addFormSpecificData("individualName", individualName);
        }
        String individualType = vreq.getParameter("individualType");
        if (redirectUrl != null) {
            editConfiguration.addFormSpecificData("individualType", individualType);
        }
    }

    private EditConfigurationVTwo setupEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initProcessParameters(vreq, session, editConfiguration);
        editConfiguration.setEditKey(EditConfigurationVTwo.newEditKey(session));
        return editConfiguration;
    }

    private void initProcessParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        this.subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        this.predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        editConfiguration.setSubjectUri(this.subjectUri);
        editConfiguration.setPredicateUri(this.predicateUri);
        editConfiguration.setEntityToReturnTo(this.subjectUri);
        editConfiguration.setUrlPatternToReturnTo("/individual");
        if (EditConfigurationUtils.isObjectProperty(this.predicateUri, vreq)) {
            this.initObjectParameters(vreq);
            this.processObjectPropForm(vreq, editConfiguration);
        } else {
            this.processDataPropForm(vreq, session, editConfiguration);
        }
    }

    private void initObjectParameters(VitroRequest vreq) {
        this.objectUri = EditConfigurationUtils.getObjectUri(vreq);
    }

    private void processObjectPropForm(VitroRequest vreq, EditConfigurationVTwo editConfiguration) {
        editConfiguration.setObject(this.objectUri);
    }

    private void processDataPropForm(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        this.dataHash = EditConfigurationUtils.getDataHash(vreq);
        if (this.dataHash != null) {
            log.debug((Object)("Found a datapropKey in parameters and parsed it to int: " + this.dataHash));
            editConfiguration.setDatapropKey(this.dataHash);
            this.dps = EditConfigurationUtils.getDataPropertyStatement(vreq, session, this.dataHash, this.predicateUri);
            if (this.dps != null) {
                editConfiguration.addFormSpecificData("dataPropertyLexicalValue", this.dps.getData());
            } else {
                editConfiguration.addFormSpecificData("dataPropertyLexicalValue", "unknown value");
            }
        } else {
            log.debug((Object)"Did NOT find a datapropKey for hte data hash.");
            editConfiguration.addFormSpecificData("dataPropertyLexicalValue", "unknown value");
        }
    }
}

