/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors;

import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ModelChangePreprocessor;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringUtils;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class LimitRemovalsToLanguage
implements ModelChangePreprocessor {
    private static final Log log = LogFactory.getLog(LimitRemovalsToLanguage.class);
    private String language;

    public LimitRemovalsToLanguage(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale may not be null.");
        }
        this.language = LanguageFilteringUtils.localeToLanguage(locale);
    }

    public LimitRemovalsToLanguage(String language) {
        if (language == null) {
            throw new IllegalArgumentException("Language may not be null.");
        }
        this.language = language;
    }

    @Override
    public void preprocess(Model retractionsModel, Model additionsModel, HttpServletRequest request) {
        log.debug((Object)("limiting changes to " + this.language));
        ArrayList<Statement> eliminatedRetractions = new ArrayList<Statement>();
        StmtIterator sit = retractionsModel.listStatements();
        while (sit.hasNext()) {
            Literal lit;
            Statement stmt = (Statement)sit.next();
            if (!stmt.getObject().isLiteral() || StringUtils.isEmpty((CharSequence)(lit = stmt.getObject().asLiteral()).getLanguage()) || lit.getLanguage().equals(this.language)) continue;
            boolean eliminateRetraction = true;
            StmtIterator replacements = additionsModel.listStatements(stmt.getSubject(), stmt.getPredicate(), (RDFNode)null);
            if (!replacements.hasNext()) {
                eliminateRetraction = false;
            } else {
                while (replacements.hasNext()) {
                    Statement replacement = (Statement)replacements.next();
                    if (!replacement.getObject().isLiteral() || !lit.getLanguage().equals(replacement.getObject().asLiteral().getLanguage())) continue;
                    eliminateRetraction = false;
                }
            }
            if (!eliminateRetraction) continue;
            eliminatedRetractions.add(stmt);
        }
        retractionsModel.remove(eliminatedRetractions);
    }
}

