/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import edu.cornell.mannlib.vitro.webapp.i18n.I18nLogger;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nBundle {
    private static final Log log = LogFactory.getLog(I18nBundle.class);
    private static final String START_SEP = "\u25a4";
    private static final String END_SEP = "\u25a5";
    public static final String INT_SEP = "\u25a6";
    private static final String MESSAGE_BUNDLE_NOT_FOUND = "Text bundle ''{0}'' not found.";
    private static final String MESSAGE_KEY_NOT_FOUND = "Text bundle ''{0}'' has no text for ''{1}''";
    private final String bundleName;
    private final ResourceBundle resources;
    private final String notFoundMessage;
    private final I18nLogger i18nLogger;

    public static I18nBundle emptyBundle(String bundleName, I18nLogger i18nLogger) {
        return new I18nBundle(bundleName, i18nLogger);
    }

    private I18nBundle(String bundleName, I18nLogger i18nLogger) {
        this(bundleName, new EmptyResourceBundle(), MESSAGE_BUNDLE_NOT_FOUND, i18nLogger);
    }

    public I18nBundle(String bundleName, ResourceBundle resources, I18nLogger i18nLogger) {
        this(bundleName, resources, MESSAGE_KEY_NOT_FOUND, i18nLogger);
    }

    private I18nBundle(String bundleName, ResourceBundle resources, String notFoundMessage, I18nLogger i18nLogger) {
        if (bundleName == null) {
            throw new IllegalArgumentException("bundleName may not be null");
        }
        if (bundleName.isEmpty()) {
            throw new IllegalArgumentException("bundleName may not be empty");
        }
        if (resources == null) {
            throw new NullPointerException("resources may not be null.");
        }
        if (notFoundMessage == null) {
            throw new NullPointerException("notFoundMessage may not be null.");
        }
        this.bundleName = bundleName;
        this.resources = resources;
        this.notFoundMessage = notFoundMessage;
        this.i18nLogger = i18nLogger;
    }

    public String text(String key, Object ... parameters) {
        String message;
        String textString;
        if (this.resources.containsKey(key)) {
            textString = this.resources.getString(key);
            log.debug((Object)("In '" + this.bundleName + "', " + key + "='" + textString + "')"));
        } else {
            message = MessageFormat.format(this.notFoundMessage, this.bundleName, key);
            log.warn((Object)message);
            textString = "ERROR: " + message;
        }
        message = I18nBundle.formatString(textString, parameters);
        if (this.i18nLogger != null) {
            this.i18nLogger.log(this.bundleName, key, parameters, textString, message);
        }
        if (I18nBundle.isNeedExportInfo()) {
            String separatedArgs = "";
            for (int i = 0; i < parameters.length; ++i) {
                separatedArgs = separatedArgs + parameters[i] + INT_SEP;
            }
            return START_SEP + key + INT_SEP + textString + INT_SEP + separatedArgs + message + END_SEP;
        }
        return message;
    }

    private static boolean isNeedExportInfo() {
        return DeveloperSettings.getInstance().getBoolean(Key.I18N_ONLINE_TRANSLATION);
    }

    private static String formatString(String textString, Object ... parameters) {
        if (parameters.length == 0) {
            return textString;
        }
        return MessageFormat.format(textString, parameters);
    }

    public static class EmptyResourceBundle
    extends ResourceBundle {
        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(Collections.emptySet());
        }

        @Override
        protected Object handleGetObject(String key) {
            if (key == null) {
                throw new NullPointerException("key may not be null.");
            }
            return null;
        }
    }
}

