/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SparqlGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractBulkUpdater;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractOntModelDecorator;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.GraphUtils;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.RDFServiceBulkUpdater;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.SparqlBulkUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFReaderF;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.RDFReaderFImpl;
import org.apache.jena.shared.WrappedIOException;
import org.apache.jena.sparql.graph.GraphFactory;

public class BulkUpdatingOntModel
extends AbstractOntModelDecorator {
    private static final RDFReaderF readerFactory = new RDFReaderFImpl();
    private AbstractBulkUpdater updater;

    protected BulkUpdatingOntModel(OntModel m) {
        super(m);
        Graph graph;
        this.updater = m instanceof BulkUpdatingOntModel ? ((BulkUpdatingOntModel)m).updater : ((graph = GraphUtils.unwrapUnionGraphs(m.getGraph())) instanceof RDFServiceGraph ? new RDFServiceBulkUpdater((RDFServiceGraph)graph) : (graph instanceof SparqlGraph ? new SparqlBulkUpdater((SparqlGraph)graph) : null));
    }

    protected BulkUpdatingOntModel(OntModel m, OntModel baseModel) {
        super(m);
        Graph graph;
        this.updater = baseModel instanceof BulkUpdatingOntModel ? ((BulkUpdatingOntModel)baseModel).updater : ((graph = GraphUtils.unwrapUnionGraphs(baseModel.getGraph())) instanceof RDFServiceGraph ? new RDFServiceBulkUpdater((RDFServiceGraph)graph) : (graph instanceof SparqlGraph ? new SparqlBulkUpdater((SparqlGraph)graph) : null));
    }

    @Override
    public Model add(StmtIterator iter) {
        if (this.updater != null && iter != null) {
            Graph g = GraphFactory.createPlainGraph();
            while (iter.hasNext()) {
                g.add(iter.nextStatement().asTriple());
            }
            this.updater.add(g);
        } else {
            super.add(iter);
        }
        return this;
    }

    @Override
    public Model add(Model m) {
        if (this.updater != null && m != null) {
            this.updater.add(m.getGraph());
        } else {
            super.add(m);
        }
        return this;
    }

    @Override
    public Model add(Statement[] statements) {
        if (this.updater != null && statements != null) {
            Graph g = GraphFactory.createPlainGraph();
            for (Statement s : statements) {
                g.add(s.asTriple());
            }
            this.updater.add(g);
        } else {
            super.add(statements);
        }
        return this;
    }

    @Override
    public Model add(List<Statement> statements) {
        this.add(statements.toArray(new Statement[statements.size()]));
        return this;
    }

    @Override
    public Model read(String url) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader().read(m, url);
        return this.add(m);
    }

    @Override
    public Model read(Reader reader, String base) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader().read(m, reader, base);
        return this.add(m);
    }

    @Override
    public Model read(InputStream reader, String base) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader().read(m, reader, base);
        return this.add(m);
    }

    @Override
    public Model read(String url, String lang) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader(lang).read(m, url);
        return this.add(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(String url, String base, String lang) {
        try {
            InputStream is = new URL(url).openStream();
            try {
                this.read(is, base, lang);
            }
            finally {
                if (null != is) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
        return this;
    }

    @Override
    public Model read(Reader reader, String base, String lang) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader(lang).read(m, reader, base);
        return this.add(m);
    }

    @Override
    public Model read(InputStream reader, String base, String lang) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader(lang).read(m, reader, base);
        return this.add(m);
    }

    @Override
    public Model remove(StmtIterator iter) {
        if (this.updater != null && iter != null) {
            Graph g = GraphFactory.createPlainGraph();
            while (iter.hasNext()) {
                g.add(iter.nextStatement().asTriple());
            }
            this.updater.remove(g);
        } else {
            super.remove(iter);
        }
        return this;
    }

    @Override
    public Model remove(Model m) {
        if (this.updater != null && m != null) {
            this.updater.remove(m.getGraph());
        } else {
            super.remove(m);
        }
        return this;
    }

    @Override
    public Model remove(Statement[] statements) {
        if (this.updater != null && statements != null) {
            Graph g = GraphFactory.createPlainGraph();
            for (Statement s : statements) {
                g.add(s.asTriple());
            }
            this.updater.remove(g);
        } else {
            super.remove(statements);
        }
        return this;
    }

    @Override
    public Model remove(List<Statement> statements) {
        if (this.updater != null && statements != null) {
            Graph g = GraphFactory.createPlainGraph();
            for (Statement s : statements) {
                g.add(s.asTriple());
            }
            this.updater.remove(g);
        } else {
            super.remove(statements);
        }
        return this;
    }

    @Override
    public Model removeAll() {
        if (this.updater != null) {
            this.updater.removeAll();
        } else {
            super.removeAll();
        }
        return this;
    }
}

