/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractGraphDecorator;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilterModel;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class LanguageFilteringGraph
extends AbstractGraphDecorator
implements Graph {
    private List<String> langs;
    private LanguageFilterModel filterModel = new LanguageFilterModel();

    protected LanguageFilteringGraph(Graph g, List<String> preferredLanguages) {
        super(g);
        this.langs = preferredLanguages;
    }

    @Override
    public ExtendedIterator<Triple> find(Triple arg0) {
        return this.filter(super.find(arg0));
    }

    @Override
    public ExtendedIterator<Triple> find(Node arg0, Node arg1, Node arg2) {
        return this.filter(super.find(arg0, arg1, arg2));
    }

    private ExtendedIterator<Triple> filter(ExtendedIterator<Triple> triples) {
        GraphMem tmp = new GraphMem();
        while (triples.hasNext()) {
            Triple t = (Triple)triples.next();
            tmp.add(t);
        }
        Model filteredModel = this.filterModel.filterModel(ModelFactory.createModelForGraph((Graph)tmp), this.langs);
        return filteredModel.getGraph().find();
    }
}

