/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.RDFServiceJena;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;

public class RDFServiceModel
extends RDFServiceJena
implements RDFService {
    private static final Log log = LogFactory.getLog(RDFServiceModel.class);
    private Model model;
    private Dataset dataset;
    private String modelName;
    private VitroRequest vitroRequest;

    public RDFServiceModel(Model model) {
        this.model = model;
    }

    public RDFServiceModel(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    protected DatasetWrapper getDatasetWrapper() {
        Dataset d = null;
        if (this.dataset != null) {
            d = this.dataset;
        } else {
            d = DatasetFactory.createMem();
            if (this.modelName == null) {
                d.setDefaultModel(this.model);
            } else {
                d.addNamedModel(this.modelName, this.model);
            }
        }
        DatasetWrapper datasetWrapper = new DatasetWrapper(d);
        return datasetWrapper;
    }

    @Override
    public boolean changeSetUpdate(ChangeSet changeSet) throws RDFServiceException {
        if (changeSet.getPreconditionQuery() != null && !this.isPreconditionSatisfied(changeSet.getPreconditionQuery(), changeSet.getPreconditionQueryType())) {
            return false;
        }
        try {
            for (Object o : changeSet.getPreChangeEvents()) {
                this.notifyListenersOfEvent(o);
            }
            for (ModelChange modelChange : changeSet.getModelChanges()) {
                if (!modelChange.getSerializedModel().markSupported()) {
                    byte[] bytes = IOUtils.toByteArray((InputStream)modelChange.getSerializedModel());
                    modelChange.setSerializedModel(new ByteArrayInputStream(bytes));
                }
                modelChange.getSerializedModel().mark(Integer.MAX_VALUE);
                Model m = this.model;
                if (m == null && this.dataset != null) {
                    String changeGraphURI = modelChange.getGraphURI();
                    m = changeGraphURI != null ? this.dataset.getNamedModel(changeGraphURI) : this.dataset.getDefaultModel();
                }
                this.operateOnModel(m, modelChange, null);
            }
            this.notifyListenersOfChanges(changeSet);
            for (Object o : changeSet.getPostChangeEvents()) {
                this.notifyListenersOfEvent(o);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RDFServiceException(e);
        }
        return true;
    }

    @Override
    public void setVitroRequest(VitroRequest vitroRequest) {
        this.vitroRequest = vitroRequest;
    }

    @Override
    public VitroRequest getVitroRequest() {
        return this.vitroRequest;
    }
}

