/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.virtuoso;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.sparql.RDFServiceSparql;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class RDFServiceVirtuoso
extends RDFServiceSparql {
    private static final Log log = LogFactory.getLog(RDFServiceVirtuoso.class);
    private final String username;
    private final String password;

    public RDFServiceVirtuoso(String baseURI, String username, String password) {
        super(RDFServiceVirtuoso.figureReadEndpointUri(baseURI), RDFServiceVirtuoso.figureUpdateEndpointUri(baseURI, username));
        this.username = username;
        this.password = password;
        this.testConnection();
    }

    private static String figureReadEndpointUri(String baseUri) {
        return RDFServiceVirtuoso.noTrailingSlash(baseUri) + "/sparql/";
    }

    private static String figureUpdateEndpointUri(String baseUri, String username) {
        return RDFServiceVirtuoso.noTrailingSlash(baseUri) + "/DAV/home/" + username + "/rdf_sink/vitro_update";
    }

    private static String noTrailingSlash(String uri) {
        return uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeUpdate(String updateString) throws RDFServiceException {
        block18: {
            updateString = this.tweakUpdateStringSyntax(updateString);
            log.debug((Object)("UPDATE STRING: " + updateString));
            try {
                HttpPost request = this.createHttpRequest(updateString);
                HttpContext context = this.getContext((HttpRequestBase)request);
                HttpResponse response = context != null ? this.httpClient.execute((HttpUriRequest)request, context) : this.httpClient.execute((HttpUriRequest)request);
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode <= 399) break block18;
                    log.error((Object)("response " + response.getStatusLine() + " to update. \n"));
                    try (InputStream content = response.getEntity().getContent();){
                        for (String line : IOUtils.readLines((InputStream)content)) {
                            log.error((Object)("response-line >>" + line));
                        }
                    }
                    throw new RDFServiceException("Unable to perform SPARQL UPDATE: status code = " + statusCode);
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to update: " + updateString), (Throwable)e);
                throw new RDFServiceException("Unable to perform change set update", e);
            }
        }
    }

    private String tweakUpdateStringSyntax(String updateString) {
        if (updateString.startsWith("INSERT DATA")) {
            return updateString.replaceFirst("INSERT DATA", "INSERT");
        }
        return updateString;
    }

    private HttpPost createHttpRequest(String updateString) {
        HttpPost meth = new HttpPost(this.updateEndpointURI);
        meth.addHeader("Content-Type", "application/sparql-query");
        meth.setEntity((HttpEntity)new StringEntity(updateString, "UTF-8"));
        return meth;
    }

    @Override
    protected UsernamePasswordCredentials getCredentials() {
        if (this.username != null && this.password != null) {
            return new UsernamePasswordCredentials(this.username, this.password);
        }
        return null;
    }

    private static boolean isNumeric(String typeUri) {
        return typeUri != null && (typeUri.endsWith("decimal") || typeUri.endsWith("int") || typeUri.endsWith("integer") || typeUri.endsWith("float") || typeUri.endsWith("long") || typeUri.endsWith("negativeInteger") || typeUri.endsWith("nonNegativeInteger") || typeUri.endsWith("nonPositiveInteger") || typeUri.endsWith("positiveInteger") || typeUri.endsWith("short") || typeUri.endsWith("unsignedLong") || typeUri.endsWith("unsignedInt") || typeUri.endsWith("unsignedShort") || typeUri.endsWith("unsignedByte"));
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, InputStream serializedGraph, RDFService.ModelSerializationFormat serializationFormat) throws RDFServiceException {
        Model fileModel = RDFServiceUtils.parseModel(serializedGraph, serializationFormat);
        Model tripleStoreModel = new RDFServiceDataset(this).getNamedModel(graphURI);
        Model fromTripleStoreModel = ModelFactory.createDefaultModel().add(tripleStoreModel);
        Model difference = fileModel.difference(fromTripleStoreModel);
        if (difference.size() > 0L) {
            StmtIterator stmtIterator = difference.listStatements();
            while (stmtIterator.hasNext()) {
                Statement stmt = (Statement)stmtIterator.next();
                Resource subject = stmt.getSubject();
                Property predicate = stmt.getPredicate();
                final RDFNode object = stmt.getObject();
                if (!object.isLiteral() || !RDFServiceVirtuoso.isNumeric(object.asLiteral().getDatatypeURI())) continue;
                StmtIterator matching = fromTripleStoreModel.listStatements(new Selector((RDFNode)subject, predicate){
                    final /* synthetic */ RDFNode val$subject;
                    final /* synthetic */ Property val$predicate;
                    {
                        this.val$subject = rDFNode2;
                        this.val$predicate = property;
                    }

                    public boolean test(Statement statement) {
                        RDFNode objectToMatch = statement.getObject();
                        if (objectToMatch.isLiteral()) {
                            String num1 = object.asLiteral().getString();
                            String num2 = objectToMatch.asLiteral().getString();
                            return Double.parseDouble(num1) == Double.parseDouble(num2);
                        }
                        return false;
                    }

                    public boolean isSimple() {
                        return false;
                    }

                    public Resource getSubject() {
                        return this.val$subject.asResource();
                    }

                    public Property getPredicate() {
                        return this.val$predicate;
                    }

                    public RDFNode getObject() {
                        return null;
                    }
                });
                ArrayList<Statement> toModify = new ArrayList<Statement>();
                while (matching.hasNext()) {
                    toModify.add((Statement)matching.next());
                }
                for (Statement stmtToModify : toModify) {
                    stmtToModify.changeObject(object);
                }
            }
            return fileModel.isIsomorphicWith(fromTripleStoreModel);
        }
        return true;
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, Model graph) throws RDFServiceException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        graph.write((OutputStream)buffer, "N-TRIPLE");
        ByteArrayInputStream inStream = new ByteArrayInputStream(buffer.toByteArray());
        return this.isEquivalentGraph(graphURI, inStream, RDFService.ModelSerializationFormat.NTRIPLE);
    }

    private InputStream adjustForNonNegativeIntegers(InputStream serializedGraph) throws RDFServiceException {
        try {
            String raw = IOUtils.toString((InputStream)serializedGraph, (String)"UTF-8");
            String modified = raw.replace("nonNegativeInteger", "integer");
            return new ByteArrayInputStream(modified.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RDFServiceException(e);
        }
    }
}

