/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.exclusions;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluder;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import java.util.ArrayList;
import java.util.List;

public class ExcludeBasedOnNamespace
implements SearchIndexExcluder {
    private List<String> excludeNamespaces = new ArrayList<String>();

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#excludes")
    public void addExcludedNamespace(String ns) {
        this.excludeNamespaces.add(ns);
    }

    @Override
    public String checkForExclusion(Individual ind) {
        for (String ns : this.excludeNamespaces) {
            if (!ns.equals(ind.getNamespace())) continue;
            return "skipping because of namespace " + ns;
        }
        return null;
    }

    public String toString() {
        return "ExcludeBasedOnNamespace[namespaces=" + this.excludeNamespaces + "]";
    }
}

