/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.RDFFilesLoader;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.SimpleReasonerSetup;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class FileGraphSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(FileGraphSetup.class);
    private static final String RDF = "rdf";
    private static final String I18N = "i18n";
    private static final String ABOX = "abox";
    private static final String TBOX = "tbox";
    private static final String FILEGRAPH = "filegraph";
    public static final String FILEGRAPH_URI_ROOT = "http://vitro.mannlib.cornell.edu/filegraph/";
    private static final DirectoryStream.Filter<Path> REJECT_HIDDEN_FILES = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) throws IOException {
            return !Files.isHidden(entry);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        boolean aboxChanged = false;
        boolean tboxChanged = false;
        ServletContext ctx = sce.getServletContext();
        try {
            OntDocumentManager.getInstance().setProcessImports(true);
            Dataset dataset = ModelAccess.on(ctx).getDataset();
            RDFService rdfService = ModelAccess.on(ctx).getRDFService(ModelAccess.WhichService.CONTENT);
            Set<Path> paths = this.getFilegraphPaths(ctx, RDF, ABOX, FILEGRAPH);
            Set<String> enabledLocales = RDFFilesLoader.getEnabledLocales(ctx);
            for (String locale : enabledLocales) {
                paths.addAll(this.getFilegraphPaths(ctx, RDF, I18N, locale, ABOX, FILEGRAPH));
            }
            this.cleanupDB(dataset, this.pathsToURIs(paths, ABOX), ABOX);
            aboxChanged = this.readGraphs(paths, rdfService, ABOX, null);
            paths = this.getFilegraphPaths(ctx, RDF, TBOX, FILEGRAPH);
            for (String locale : enabledLocales) {
                paths.addAll(this.getFilegraphPaths(ctx, RDF, I18N, locale, TBOX, FILEGRAPH));
            }
            this.cleanupDB(dataset, this.pathsToURIs(paths, TBOX), TBOX);
            OntModel tboxBaseModel = ModelAccess.on(ctx).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
            tboxChanged = this.readGraphs(paths, rdfService, TBOX, tboxBaseModel);
        }
        catch (ClassCastException cce) {
            String errMsg = "Unable to cast servlet context attribute to the appropriate type " + cce.getLocalizedMessage();
            log.error((Object)errMsg);
            throw new ClassCastException(errMsg);
        }
        catch (Throwable t) {
            log.error((Object)t, t);
        }
        finally {
            OntDocumentManager.getInstance().setProcessImports(false);
        }
        if ((aboxChanged || tboxChanged) && !FileGraphSetup.isUpdateRequired(ctx)) {
            log.info((Object)"a full recompute of the Abox will be performed because the filegraph abox(s) and/or tbox(s) have changed or are being read for the first time.");
            SimpleReasonerSetup.setRecomputeRequired(ctx, SimpleReasonerSetup.RecomputeMode.BACKGROUND);
        }
    }

    private Set<Path> getFilegraphPaths(ServletContext ctx, String ... strings) {
        StartupStatus ss = StartupStatus.getBean(ctx);
        String homeDirProperty = ApplicationUtils.instance().getHomeDirectory().getPath().toString();
        Path filegraphDir = Paths.get(homeDirProperty, strings);
        TreeSet<Path> paths = new TreeSet<Path>();
        if (Files.isDirectory(filegraphDir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(filegraphDir, REJECT_HIDDEN_FILES);){
                for (Path p : stream) {
                    paths.add(p);
                }
                ss.info(this, "Read " + paths.size() + " RDF files from '" + filegraphDir + "'");
            }
            catch (IOException e) {
                ss.fatal(this, "Failed to read filegraph RDF from '" + filegraphDir + "' directory.", e);
            }
        } else {
            ss.info(this, "Filegraph directory '" + filegraphDir + "' doesn't exist.");
        }
        log.debug((Object)("Paths from '" + filegraphDir + "': " + paths));
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readGraphs(Set<Path> pathSet, RDFService rdfService, String type, OntModel baseModel) {
        int count = 0;
        boolean modelChanged = false;
        for (Path p : pathSet) {
            ++count;
            try (FileInputStream fis = new FileInputStream(p.toFile());){
                OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                String fn = p.getFileName().toString().toLowerCase();
                if (fn.endsWith(".nt")) {
                    model.read((InputStream)fis, null, "N-TRIPLE");
                } else if (fn.endsWith(".n3")) {
                    model.read((InputStream)fis, null, "N3");
                } else if (fn.endsWith(".ttl")) {
                    model.read((InputStream)fis, null, "TURTLE");
                } else if (fn.endsWith(".owl") || fn.endsWith(".rdf") || fn.endsWith(".xml")) {
                    model.read((InputStream)fis, null, "RDF/XML");
                } else if (!fn.endsWith(".md")) {
                    log.warn((Object)("Ignoring " + type + " file graph " + p + " because the file extension is unrecognized."));
                }
                if (!model.isEmpty() && baseModel != null) {
                    baseModel.addSubModel((Model)model);
                    log.debug((Object)("Attached file graph as " + type + " submodel " + p.getFileName()));
                }
                modelChanged |= this.updateGraphInDB(rdfService, (Model)model, type, p);
            }
            catch (FileNotFoundException fnfe) {
                log.warn((Object)(p + " not found. Unable to process file graph" + (fnfe.getLocalizedMessage() != null ? fnfe.getLocalizedMessage() : "")));
            }
            catch (IOException ioe) {
                log.warn((Object)("Exception while trying to close file graph file: " + p), (Throwable)ioe);
            }
        }
        log.info((Object)("Read " + count + " " + type + " file graph" + (count == 1 ? "" : "s")));
        return modelChanged;
    }

    public boolean updateGraphInDB(RDFService rdfService, Model fileModel, String type, Path path) throws RDFServiceException {
        String graphURI = this.pathToURI(path, type);
        if (rdfService.isEquivalentGraph(graphURI, fileModel)) {
            return false;
        }
        Model dbModel = new RDFServiceDataset(rdfService).getNamedModel(graphURI);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s %s dbModel size is %d, fileModel size is %d", type, path.getFileName(), dbModel.size(), fileModel.size()));
        }
        log.info((Object)("Updating " + path + " because graphs are not isomorphic"));
        log.info((Object)("dbModel: " + dbModel.size() + " ; fileModel: " + fileModel.size()));
        dbModel.removeAll();
        dbModel.add(fileModel);
        return true;
    }

    public void cleanupDB(Dataset dataset, Set<String> uriSet, String type) {
        Pattern graphURIPat = Pattern.compile("^http://vitro.mannlib.cornell.edu/filegraph/" + type);
        Iterator iter = dataset.listNames();
        while (iter.hasNext()) {
            String graphURI = (String)iter.next();
            Matcher matcher = graphURIPat.matcher(graphURI);
            if (!matcher.find() || uriSet.contains(graphURI)) continue;
            Model model = dataset.getNamedModel(graphURI);
            model.removeAll();
            log.info((Object)("Removed " + type + " file graph " + graphURI + " from the DB store because the file no longer exists in the file system"));
        }
    }

    private Set<String> pathsToURIs(Set<Path> paths, String type) {
        HashSet<String> uriSet = new HashSet<String>();
        for (Path path : paths) {
            uriSet.add(this.pathToURI(path, type));
        }
        log.debug((Object)("uriSet = " + uriSet));
        return uriSet;
    }

    private String pathToURI(Path path, String type) {
        return FILEGRAPH_URI_ROOT + type + "/" + path.getFileName();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private static boolean isUpdateRequired(ServletContext ctx) {
        return ctx.getAttribute("KNOWLEDGE_BASE_MIGRATION_REQUIRED_AT_STARTUP") != null;
    }
}

