/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.ElasticSmokeTest;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.SolrSmokeTest;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchEngineSmokeTest
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(SearchEngineSmokeTest.class);

    public void contextInitialized(ServletContextEvent sce) {
        StartupStatus ss = StartupStatus.getBean(sce.getServletContext());
        String solrUrlString = ConfigurationProperties.getBean(sce).getProperty("vitro.local.solr.url", "");
        String elasticUrlString = ConfigurationProperties.getBean(sce).getProperty("vitro.local.elastic.url", "");
        if (!solrUrlString.isEmpty() && !elasticUrlString.isEmpty()) {
            ss.fatal(this, "More than one search engine is configured: " + solrUrlString + ", and " + elasticUrlString);
        } else if (solrUrlString.isEmpty() && elasticUrlString.isEmpty()) {
            ss.fatal(this, "No search engine is configured");
        } else if (!solrUrlString.isEmpty()) {
            log.debug((Object)("Initializing Solr: " + solrUrlString));
            new SolrSmokeTest(this).doTest(sce);
        } else {
            log.debug((Object)("Initializing ElasticSearch: " + elasticUrlString));
            new ElasticSmokeTest(this).doTest(sce);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

