/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;

public class ThemeInfoSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ThemeInfoSetup.class);

    public void contextInitialized(ServletContextEvent sce) {
        String defaultThemeName;
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        String themeDirPath = ctx.getRealPath("/themes");
        if (themeDirPath == null) {
            throw new IllegalStateException("Application does not have a /themes directory.");
        }
        File themesBaseDir = new File(themeDirPath);
        List<String> themeNames = this.getThemeNames(themesBaseDir);
        log.debug((Object)("themeNames: " + themeNames));
        if (themeNames.isEmpty()) {
            ss.fatal(this, "The application contains no themes. '" + themesBaseDir.getAbsolutePath() + "' has no child directories.");
        }
        if (!themeNames.contains(defaultThemeName = "vitro")) {
            defaultThemeName = themeNames.get(0);
        }
        log.debug((Object)("defaultThemeName: " + defaultThemeName));
        String currentThemeName = this.getCurrentThemeName(ctx);
        log.debug((Object)("currentThemeName: " + currentThemeName));
        if (currentThemeName != null && !currentThemeName.isEmpty() && !themeNames.contains(currentThemeName)) {
            ss.warning(this, "The current theme selection is '" + currentThemeName + "', but that theme is not available. The '" + defaultThemeName + "' theme will be used instead. Go to the Site Admin page and choose \"Site Information\" to select a theme.");
        }
        ApplicationBean.themeInfo = new ApplicationBean.ThemeInfo(themesBaseDir, defaultThemeName, themeNames);
        ss.info(this, "current theme: " + currentThemeName + ", default theme: " + defaultThemeName + ", available themes: " + themeNames);
    }

    private List<String> getThemeNames(File themesBaseDir) {
        ArrayList<String> themeNames = new ArrayList<String>();
        for (File child : themesBaseDir.listFiles()) {
            if (!child.isDirectory()) continue;
            themeNames.add(child.getName());
        }
        themeNames.sort(String.CASE_INSENSITIVE_ORDER);
        return themeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentThemeName(ServletContext ctx) {
        OntModel ontModel = ModelAccess.on(ctx).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata");
        ontModel.enterCriticalSection(true);
        try {
            NodeIterator nodes;
            block10: {
                String string;
                Property property = ontModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#themeDir");
                nodes = ontModel.listObjectsOfProperty(property);
                try {
                    if (!nodes.hasNext()) break block10;
                    String themeDir = ((Literal)nodes.next()).getString();
                    string = ApplicationBean.ThemeInfo.themeNameFromDir(themeDir);
                }
                catch (Throwable throwable) {
                    try {
                        nodes.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                        String string2 = null;
                        return string2;
                    }
                }
                nodes.close();
                return string;
            }
            String string = null;
            nodes.close();
            return string;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

