/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.beanswrappers;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MethodAppearanceFineTuner;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadOnlyBeansWrapper
extends BeansWrapper {
    private static final Log log = LogFactory.getLog(ReadOnlyBeansWrapper.class);

    public ReadOnlyBeansWrapper() {
        this.setExposureLevel(1);
        this.setMethodAppearanceFineTuner(new MethodAppearanceFineTuner(){

            public void process(BeansWrapper.MethodAppearanceDecisionInput methodAppearanceDecisionInput, BeansWrapper.MethodAppearanceDecision methodAppearanceDecision) {
                Method method = methodAppearanceDecisionInput.getMethod();
                if (method.getName().startsWith("set")) {
                    methodAppearanceDecision.setExposeMethodAs(null);
                } else if (method.getReturnType().getName().equals("void")) {
                    methodAppearanceDecision.setExposeMethodAs(null);
                } else {
                    Class<?> declaringClass = method.getDeclaringClass();
                    if (declaringClass.equals(Object.class)) {
                        methodAppearanceDecision.setExposeMethodAs(null);
                    } else {
                        Package pkg = declaringClass.getPackage();
                        if (pkg.getName().equals("java.util")) {
                            methodAppearanceDecision.setExposeMethodAs(null);
                        }
                    }
                }
            }
        });
    }
}

