/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.directives;

import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailMessage;
import edu.cornell.mannlib.vitro.webapp.web.directives.BaseTemplateDirectiveModel;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmailDirective
extends BaseTemplateDirectiveModel {
    private static final Log log = LogFactory.getLog(EmailDirective.class);
    private final FreemarkerEmailMessage message;

    public EmailDirective(FreemarkerEmailMessage message) {
        this.message = message;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String textContent;
        String htmlContent;
        String subject = this.getOptionalSimpleScalarParameter(params, "subject");
        if (subject != null) {
            this.message.setSubject(subject);
        }
        if ((htmlContent = this.getOptionalSimpleScalarParameter(params, "html")) != null) {
            this.message.setHtmlContent(htmlContent);
        }
        if ((textContent = this.getOptionalSimpleScalarParameter(params, "text")) != null) {
            this.message.setTextContent(textContent);
        }
        if (htmlContent == null && textContent == null) {
            throw new TemplateModelException("The email directive must have either a 'html' parameter or a 'text' parameter.");
        }
    }

    @Override
    public Map<String, Object> help(String name) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("effect", "Create an email message from the parameters set in the invoking template.");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subject", "email subject (optional)");
        params.put("html", "HTML version of email message (optional)");
        params.put("text", "Plain text version of email message (optional)");
        map.put("parameters", params);
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("&lt;email subject=\"Password reset confirmation\" html=html text=text&gt;");
        examples.add("&lt;email html=html text=text&gt;");
        map.put("examples", examples);
        return map;
    }
}

