/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels;

import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseTemplateModel {
    private static final Log log = LogFactory.getLog(BaseTemplateModel.class);
    private static final String URI_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&%'()*+,;=";
    private static final Pattern stripJavascript = Pattern.compile("(<script\\b[^<]*(?:(?!</script>)<[^<]*)*</script>)|( on[a-z]*=\"(?:[^\\\\\"]|\\\\.)*\")");

    protected String getUrl(String path) {
        return UrlBuilder.getUrl(path);
    }

    protected String getUrl(String path, UrlBuilder.ParamMap params) {
        return UrlBuilder.getUrl(path, params);
    }

    protected String getUrl(String path, String ... params) {
        return UrlBuilder.getUrl(path, params);
    }

    protected String cleanURIForDisplay(String dirty) {
        if (dirty == null) {
            return null;
        }
        StringBuilder clean = new StringBuilder(dirty.length());
        for (char ch : dirty.toCharArray()) {
            if (URI_CHARACTERS.indexOf(ch) == -1) continue;
            clean.append(ch);
        }
        return clean.toString();
    }

    protected String cleanTextForDisplay(String dirty) {
        return this.simpleScriptStripper(dirty);
    }

    protected <T> void cleanMapValuesForDisplay(Map<T, String> map) {
        for (T key : map.keySet()) {
            map.put(key, this.simpleScriptStripper(map.get(key)));
        }
    }

    protected String simpleScriptStripper(String dirtyInput) {
        if (dirtyInput == null) {
            return null;
        }
        if (dirtyInput.contains("<script") || dirtyInput.contains(" on")) {
            return stripJavascript.matcher(dirtyInput).replaceAll("");
        }
        return dirtyInput;
    }
}

