/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividual;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividualBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseListedIndividual
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog(BaseListedIndividual.class);
    protected final Individual individual;
    protected final VitroRequest vreq;

    public BaseListedIndividual(Individual individual, VitroRequest vreq) {
        this.vreq = vreq;
        this.individual = individual;
    }

    public static List<ListedIndividual> getIndividualTemplateModels(List<Individual> individuals, VitroRequest vreq) {
        ArrayList<ListedIndividual> models = new ArrayList<ListedIndividual>(individuals.size());
        for (Individual individual : individuals) {
            models.add(ListedIndividualBuilder.build(individual, vreq));
        }
        return models;
    }

    public String getProfileUrl() {
        return this.cleanURIForDisplay(UrlBuilder.getIndividualProfileUrl(this.individual, this.vreq));
    }

    public String getImageUrl() {
        String imageUrl = this.individual.getImageUrl();
        return imageUrl == null ? null : this.getUrl(imageUrl);
    }

    public String getThumbUrl() {
        String thumbUrl = this.individual.getThumbUrl();
        return thumbUrl == null ? null : this.getUrl(thumbUrl);
    }

    public String getName() {
        return this.cleanTextForDisplay(this.individual.getName());
    }

    public String getUri() {
        return this.cleanURIForDisplay(this.individual.getURI());
    }

    public List<String> getMostSpecificTypes() {
        ObjectPropertyStatementDao opsDao = this.vreq.getWebappDaoFactory().getObjectPropertyStatementDao();
        Map<String, String> types = opsDao.getMostSpecificTypesInClassgroupsForIndividual(this.individual.getURI());
        ArrayList<String> typeLabels = new ArrayList<String>(types.size());
        String displayedType = (String)this.vreq.getAttribute("displayType");
        for (String type : types.keySet()) {
            if (type.equals(displayedType)) continue;
            typeLabels.add(types.get(type));
        }
        return typeLabels;
    }
}

