/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RDFTermParser<TermType> {
    public static final Pattern STRINGPATTERN = Pattern.compile("^\"(.*)\"(?:@(.*)|\\^\\^<?([^<>]*)>?)?$");

    public TermType parseIntoRDFNode(String param) {
        if (param == null || param.isEmpty()) {
            return this.handleUnparsableParameter(param);
        }
        char firstChar = param.charAt(0);
        switch (firstChar) {
            case '_': {
                return this.createBlankNode(param);
            }
            case '<': {
                return this.createURI(param.substring(1, param.length() - 1));
            }
            case '\"': {
                Matcher matcher = STRINGPATTERN.matcher(param);
                if (matcher.matches()) {
                    String label = matcher.group(1);
                    String langTag = matcher.group(2);
                    String typeURI = matcher.group(3);
                    if (langTag != null) {
                        return this.createLanguageLiteral(label, langTag);
                    }
                    if (typeURI != null) {
                        return this.createTypedLiteral(label, typeURI);
                    }
                    return this.createPlainLiteral(label);
                }
                return this.handleUnparsableParameter(param);
            }
        }
        return this.createURI(param);
    }

    public abstract TermType createBlankNode(String var1);

    public abstract TermType createURI(String var1);

    public abstract TermType createTypedLiteral(String var1, String var2);

    public abstract TermType createLanguageLiteral(String var1, String var2);

    public abstract TermType createPlainLiteral(String var1);

    public abstract TermType handleUnparsableParameter(String var1);
}

