/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasProfile;
import edu.cornell.mannlib.vitro.webapp.auth.policy.SelfEditingPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.admin.AddNewUser;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.admin.LoadOntology;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.admin.RebuildTextIndex;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.admin.RemoveUser;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.admin.ServerStatus;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.admin.UpdateTextIndex;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.ontology.CreateOwlClass;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.ontology.DefineDataProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.ontology.DefineObjectProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.ontology.RemoveOwlClass;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.DropObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import javax.servlet.ServletContext;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBeanStub;
import stubs.javax.servlet.ServletContextStub;

public class SelfEditingPolicyTest
extends AbstractTestClass {
    private static final String SAFE_NS = "http://test.mannlib.cornell.edu/ns/01#";
    private static final String UNSAFE_NS = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#";
    private static final String SELFEDITOR_URI = "http://test.mannlib.cornell.edu/ns/01#individual244";
    private static final String SAFE_RESOURCE = "http://test.mannlib.cornell.edu/ns/01#otherIndividual77777";
    private static final String UNSAFE_RESOURCE = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#otherIndividual99999";
    private static final Property SAFE_PREDICATE = new Property("http://test.mannlib.cornell.edu/ns/01#hasHairStyle");
    private static final Property UNSAFE_PREDICATE = new Property("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hasSuperPowers");
    private ServletContextStub ctx;
    private SelfEditingPolicy policy;
    private IdentifierBundle ids;
    private RequestedAction whatToAuth;
    private OntModel ontModel;

    @Override
    @Before
    public void setUp() {
        this.ctx = new ServletContextStub();
        PropertyRestrictionBeanStub.getInstance(new String[]{UNSAFE_NS});
        this.policy = new SelfEditingPolicy((ServletContext)this.ctx);
        IndividualImpl ind = new IndividualImpl();
        ind.setURI(SELFEDITOR_URI);
        this.ids = new ArrayIdentifierBundle(new Identifier[]{new HasProfile(SELFEDITOR_URI)});
        this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    }

    @Test
    public void testProhibitedProperties() {
        PropertyRestrictionBeanStub.getInstance(new String[]{UNSAFE_NS}, new String[]{"http://mannlib.cornell.edu/bad#prp234", "http://mannlib.cornell.edu/bad#prp999", "http://mannlib.cornell.edu/bad#prp333", "http://mannlib.cornell.edu/bad#prp777", "http://mannlib.cornell.edu/bad#prp0020"});
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, new Property("http://mannlib.cornell.edu/bad#prp234"), SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, new Property("http://mannlib.cornell.edu/bad#prp234"), SELFEDITOR_URI);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, new Property("http://mannlib.cornell.edu/bad#prp999"), SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, new Property("http://mannlib.cornell.edu/bad#prp999"), SELFEDITOR_URI);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE, SELFEDITOR_URI);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, UNSAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddDataPropertyStatement(this.ontModel, SELFEDITOR_URI, "http://mannlib.cornell.edu/bad#prp234", RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddDataPropertyStatement(this.ontModel, SELFEDITOR_URI, "http://mannlib.cornell.edu/bad#prp999", RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddDataPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE.getURI(), RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddDataPropertyStatement(this.ontModel, SELFEDITOR_URI, UNSAFE_PREDICATE.getURI(), RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    @Test
    public void testVisitIdentifierBundleAddObjectPropStmt() {
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE, SELFEDITOR_URI);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, UNSAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new AddObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE, UNSAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    @Test
    public void testVisitIdentifierBundleDropObjectPropStmt() {
        this.whatToAuth = new DropObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new DropObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE, SELFEDITOR_URI);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new DropObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new DropObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, UNSAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new DropObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE, UNSAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    @Test
    public void testVisitIdentifierBundleEditDataPropStmt() {
        this.whatToAuth = new EditDataPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE.getURI(), RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new EditDataPropertyStatement(this.ontModel, SELFEDITOR_URI, UNSAFE_PREDICATE.getURI(), RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new EditDataPropertyStatement(this.ontModel, UNSAFE_RESOURCE, SAFE_PREDICATE.getURI(), RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new EditDataPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE.getURI(), RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    @Test
    public void testVisitIdentifierBundleEditObjPropStmt() {
        this.whatToAuth = new EditObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new EditObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE, SELFEDITOR_URI);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new EditObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new EditObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, UNSAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
        this.whatToAuth = new EditObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE, UNSAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    @Test
    public void twoSEIsFindObjectPropertySubject() {
        this.setUpTwoSEIs();
        this.whatToAuth = new DropObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    @Test
    public void twoSEIsFindObjectPropertyObject() {
        this.setUpTwoSEIs();
        this.whatToAuth = new DropObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE, SELFEDITOR_URI);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    @Test
    public void twoSEIsDontFindInObjectProperty() {
        this.setUpTwoSEIs();
        this.whatToAuth = new DropObjectPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE, SAFE_RESOURCE);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    @Test
    public void twoSEIsFindDataPropertySubject() {
        this.setUpTwoSEIs();
        this.whatToAuth = new EditDataPropertyStatement(this.ontModel, SELFEDITOR_URI, SAFE_PREDICATE.getURI(), RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.AUTHORIZED, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    @Test
    public void twoSEIsDontFindInDataProperty() {
        this.setUpTwoSEIs();
        this.whatToAuth = new EditDataPropertyStatement(this.ontModel, SAFE_RESOURCE, SAFE_PREDICATE.getURI(), RequestedAction.SOME_LITERAL);
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, this.whatToAuth));
    }

    private void setUpTwoSEIs() {
        this.ids = new ArrayIdentifierBundle(new Identifier[0]);
        IndividualImpl ind1 = new IndividualImpl();
        ind1.setURI("http://test.mannlib.cornell.edu/ns/01#bozoUri");
        this.ids.add((Object)new HasProfile(ind1.getURI()));
        IndividualImpl ind2 = new IndividualImpl();
        ind2.setURI(SELFEDITOR_URI);
        this.ids.add((Object)new HasProfile(ind2.getURI()));
    }

    @Test
    public void testServerStatus() {
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)new ServerStatus()));
    }

    @Test
    public void testCreateOwlClass() {
        CreateOwlClass a = new CreateOwlClass();
        a.setSubjectUri("http://someClass/test");
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)a));
    }

    @Test
    public void testRemoveOwlClass() {
        RemoveOwlClass a = new RemoveOwlClass();
        a.setSubjectUri("http://someClass/test");
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)a));
    }

    @Test
    public void testDefineDataProperty() {
        DefineDataProperty a = new DefineDataProperty();
        a.setSubjectUri("http://someClass/test");
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)a));
    }

    @Test
    public void testDefineObjectProperty() {
        DefineObjectProperty a = new DefineObjectProperty();
        a.setSubjectUri("http://someClass/test");
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)a));
    }

    @Test
    public void testAddNewUser() {
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)new AddNewUser()));
    }

    @Test
    public void testRemoveUser() {
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)new RemoveUser()));
    }

    @Test
    public void testLoadOntology() {
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)new LoadOntology()));
    }

    @Test
    public void testRebuildTextIndex() {
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)new RebuildTextIndex()));
    }

    @Test
    public void testVisitIdentifierBundleUpdateTextIndex() {
        this.assertDecision(Authorization.INCONCLUSIVE, this.policy.isAuthorized(this.ids, (RequestedAction)new UpdateTextIndex()));
    }

    private void assertDecision(Authorization expectedAuth, PolicyDecision decision) {
        if (expectedAuth == null) {
            Assert.assertNull((String)"expecting null decision", (Object)decision);
        } else {
            Assert.assertNotNull((String)"expecting a decision", (Object)decision);
            Assert.assertEquals((String)"wrong authorization", (Object)expectedAuth, (Object)decision.getAuthorized());
        }
    }
}

