/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.update.GraphStore;
import org.apache.jena.update.GraphStoreFactory;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SparqlUpdateApiTest
extends AbstractTestClass {
    private final String GRAPH_URI = "http://example.org/graph";
    private final String updateStr1 = "INSERT DATA { GRAPH <http://example.org/graph> { \n    <http://here.edu/n1> a <http://here.edu/Class1> . \n} } ; \nINSERT { GRAPH <http://example.org/graph> { \n      ?x a <http://here.edu/Class2> . \n } } WHERE { \n    GRAPH <http://example.org/graph> { ?x a <http://here.edu/Class1> } \n }";
    private final String result1 = "<http://here.edu/n1> a <http://here.edu/Class1> . \n<http://here.edu/n1> a <http://here.edu/Class2> .";
    private Model model;
    private RDFService rdfService;

    @Before
    public void setup() {
        this.model = ModelFactory.createDefaultModel();
        Dataset ds = DatasetFactory.createMem();
        ds.addNamedModel("http://example.org/graph", this.model);
        this.rdfService = new RDFServiceModel(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nullRdfService() throws Exception {
        this.model.removeAll();
        Model desiredResults = ModelFactory.createDefaultModel();
        desiredResults.read((Reader)new StringReader("<http://here.edu/n1> a <http://here.edu/Class1> . \n<http://here.edu/n1> a <http://here.edu/Class2> ."), null, "N3");
        RDFServiceDataset ds = new RDFServiceDataset(this.rdfService);
        GraphStore graphStore = GraphStoreFactory.create((Dataset)ds);
        try {
            if (ds.supportsTransactions()) {
                ds.begin(ReadWrite.WRITE);
            }
            UpdateAction.execute((UpdateRequest)UpdateFactory.create((String)"INSERT DATA { GRAPH <http://example.org/graph> { \n    <http://here.edu/n1> a <http://here.edu/Class1> . \n} } ; \nINSERT { GRAPH <http://example.org/graph> { \n      ?x a <http://here.edu/Class2> . \n } } WHERE { \n    GRAPH <http://example.org/graph> { ?x a <http://here.edu/Class1> } \n }"), (DatasetGraph)graphStore);
        }
        finally {
            if (ds.supportsTransactions()) {
                ds.commit();
                ds.end();
            }
        }
        Assert.assertEquals((String)"updateStr1 yields result1", (Object)desiredResults.toString(), (Object)this.model.toString());
    }
}

