/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.jena.ObjectPropertyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.io.OutputStream;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDFS;
import org.junit.Assert;
import org.junit.Test;

public class ObjectPropertyDaoJenaTest
extends AbstractTestClass {
    @Test
    public void testCollateBySubclass() {
        OntModel model = ModelFactory.createOntologyModel();
        WebappDaoFactoryJena wdf = new WebappDaoFactoryJena(model);
        edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op1 = new edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty();
        String propURI = "http://example.com/testObjectProp";
        op1.setURI(propURI);
        Assert.assertFalse((boolean)op1.getCollateBySubclass());
        try {
            wdf.getObjectPropertyDao().insertObjectProperty(op1);
            edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op2 = wdf.getObjectPropertyDao().getObjectPropertyByURI(propURI);
            Assert.assertNotNull((Object)op2);
            Assert.assertFalse((boolean)op2.getCollateBySubclass());
            op2.setCollateBySubclass(true);
            wdf.getObjectPropertyDao().updateObjectProperty(op2);
            edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op3 = wdf.getObjectPropertyDao().getObjectPropertyByURI(propURI);
            Assert.assertNotNull((Object)op3);
            Assert.assertTrue((boolean)op3.getCollateBySubclass());
            op3.setCollateBySubclass(false);
            wdf.getObjectPropertyDao().updateObjectProperty(op3);
            edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op4 = wdf.getObjectPropertyDao().getObjectPropertyByURI(propURI);
            Assert.assertNotNull((Object)op4);
            Assert.assertFalse((boolean)op4.getCollateBySubclass());
        }
        catch (InsertException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStubObjectProperty() {
        OntModel model = ModelFactory.createOntologyModel();
        WebappDaoFactoryJena wdf = new WebappDaoFactoryJena(model);
        edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op1 = new edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty();
        String propURI = "http://example.com/testObjectProp";
        op1.setURI(propURI);
        Assert.assertFalse((boolean)op1.getStubObjectRelation());
        try {
            wdf.getObjectPropertyDao().insertObjectProperty(op1);
            edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op2 = wdf.getObjectPropertyDao().getObjectPropertyByURI(propURI);
            Assert.assertNotNull((Object)op2);
            Assert.assertFalse((boolean)op2.getStubObjectRelation());
            op2.setStubObjectRelation(true);
            wdf.getObjectPropertyDao().updateObjectProperty(op2);
            edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op3 = wdf.getObjectPropertyDao().getObjectPropertyByURI(propURI);
            Assert.assertNotNull((Object)op3);
            Assert.assertTrue((boolean)op3.getStubObjectRelation());
            op3.setStubObjectRelation(false);
            wdf.getObjectPropertyDao().updateObjectProperty(op3);
            edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op4 = wdf.getObjectPropertyDao().getObjectPropertyByURI(propURI);
            Assert.assertNotNull((Object)op4);
            Assert.assertFalse((boolean)op4.getStubObjectRelation());
        }
        catch (InsertException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void minimalUpdates() {
        String propertyURI = "http://example.com/testObjectProp";
        OntModel superModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel subModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        superModel.addSubModel((Model)subModel);
        String rdfsLabel = "this is the rdfs label";
        String lang = "en-US";
        ObjectProperty property1 = subModel.createObjectProperty(propertyURI);
        property1.setLabel(rdfsLabel, lang);
        property1.convertToTransitiveProperty();
        property1.convertToSymmetricProperty();
        property1.convertToFunctionalProperty();
        property1.convertToInverseFunctionalProperty();
        property1.setPropertyValue(RDFS.domain, (RDFNode)subModel.createResource("http://thisIsTheDomainClassURI"));
        property1.setPropertyValue(RDFS.range, (RDFNode)subModel.createResource("http://thisIsTheRangeClassURI"));
        property1.setPropertyValue(subModel.createProperty("http://purl.obolibrary.org/obo/IAO_0000112"), (RDFNode)ResourceFactory.createLangLiteral((String)"this is the example", (String)lang));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#descriptionAnnot"), (RDFNode)ResourceFactory.createLangLiteral((String)"this is the description", (String)lang));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#publicDescriptionAnnot"), (RDFNode)ResourceFactory.createLangLiteral((String)"this is the public description", (String)lang));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayLimitAnnot"), (RDFNode)subModel.createTypedLiteral(6));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#individualSortFieldAnnot"), (RDFNode)subModel.createTypedLiteral("this is the entity sort field"));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#individualSortDirectionAnnot"), (RDFNode)subModel.createTypedLiteral("this is the entity sort direction"));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayRankAnnot"), (RDFNode)subModel.createTypedLiteral(21));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#objectIndividualSortProperty"), (RDFNode)subModel.createResource("http://thisIsTheObjectIndividualSortProperty"));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromDisplayBelowRoleLevelAnnot"), (RDFNode)subModel.createResource("http://vitro.mannlib.cornell.edu/ns/vitro/role#curator"));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#prohibitedFromUpdateBelowRoleLevelAnnot"), (RDFNode)subModel.createResource("http://vitro.mannlib.cornell.edu/ns/vitro/role#selfEditor"));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromPublishBelowRoleLevelAnnot"), (RDFNode)subModel.createResource("http://vitro.mannlib.cornell.edu/ns/vitro/role#editor"));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inPropertyGroupAnnot"), (RDFNode)subModel.createResource("http://thisIsTheInPropertyGroupURI"));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customEntryFormAnnot"), (RDFNode)subModel.createResource("http://thisIsTheCustomFormEntryURI"));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#selectFromExistingAnnot"), (RDFNode)subModel.createTypedLiteral(true));
        superModel.removeSubModel((Model)subModel);
        OntModel origSubModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        origSubModel.add((Model)subModel);
        OntModel origSuperModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        origSuperModel.add((Model)superModel);
        superModel.addSubModel((Model)subModel);
        WebappDaoFactoryJena wdfj = new WebappDaoFactoryJena(superModel);
        ObjectPropertyDaoJena pdj = (ObjectPropertyDaoJena)wdfj.getObjectPropertyDao();
        edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty objectProperty = pdj.getObjectPropertyByURI(propertyURI);
        pdj.updateObjectProperty(objectProperty);
        superModel.removeSubModel((Model)subModel);
        this.wipeOutModTime((Model)origSubModel);
        this.wipeOutModTime((Model)origSuperModel);
        this.wipeOutModTime((Model)subModel);
        this.wipeOutModTime((Model)superModel);
        Assert.assertTrue((boolean)subModel.isIsomorphicWith((Model)origSubModel));
        Assert.assertTrue((boolean)superModel.isIsomorphicWith((Model)origSuperModel));
    }

    void printModels(OntModel superModel, OntModel subModel) {
        superModel.removeSubModel((Model)subModel);
        System.out.println("\nThe sub-model has " + subModel.size() + " statements:");
        System.out.println("---------------------------------------------------");
        subModel.writeAll((OutputStream)System.out, "N3", null);
        System.out.println("\nThe super-model has " + superModel.size() + " statements:");
        System.out.println("---------------------------------------------------");
        superModel.write((OutputStream)System.out, "N3", null);
        superModel.addSubModel((Model)subModel);
    }

    void wipeOutModTime(Model model) {
        model.removeAll(null, model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#modTime"), null);
    }
}

