/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.RDFFilesLoader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.vocabulary.RDFS;
import org.junit.Assert;
import org.junit.Test;

public class RDFFilesLoaderTest
extends AbstractTestClass {
    @Test
    public void testFirsttimeUpdate() {
        String fileModelRdf = "@prefix rdfs: <" + RDFS.getURI() + "> .\n@prefix : <http://example.com/individual/> .\n:n1 rdfs:label \"fish 'n' chips\"@en-GB . \n:n1 rdfs:label \"fish and fries\"@en-US . \n:n2 rdfs:label \"tube\"@en-GB . \n:n2 rdfs:label \"Subway!\"@en-US . \n:n2 rdfs:label \"metrou\"@ro-RO . \n";
        String backupModelRdf = "@prefix rdfs: <" + RDFS.getURI() + "> .\n@prefix : <http://example.com/individual/> .\n:n1 rdfs:label \"fish 'n' chips\"@en-GB . \n:n2 rdfs:label \"tube\"@en-GB . \n:n2 rdfs:label \"nooo\"@no-NO . \n";
        String userModelRdf = "@prefix rdfs: <" + RDFS.getURI() + "> .\n@prefix : <http://example.com/individual/> .\n:n1 rdfs:label \"fish and chips\"@en-GB . \n:n2 rdfs:label \"tube\"@en-GB . \n:n2 rdfs:label \"subway\"@en-US . \n:n2 rdfs:label \"nooo\"@no-NO . \n";
        String userModelExpectedRdf = "@prefix rdfs: <" + RDFS.getURI() + "> .\n@prefix : <http://example.com/individual/> .\n:n1 rdfs:label \"fish and chips\"@en-GB . \n:n1 rdfs:label \"fish and fries\"@en-US . \n:n2 rdfs:label \"tube\"@en-GB . \n:n2 rdfs:label \"subway\"@en-US . \n:n2 rdfs:label \"metrou\"@ro-RO . \n";
        Model fileModel = ModelFactory.createDefaultModel();
        fileModel.read((Reader)new StringReader(fileModelRdf), null, "N3");
        Model backupModel = ModelFactory.createDefaultModel();
        backupModel.read((Reader)new StringReader(backupModelRdf), null, "N3");
        Model userModel = ModelFactory.createDefaultModel();
        userModel.read((Reader)new StringReader(userModelRdf), null, "N3");
        Model userModelExpected = ModelFactory.createDefaultModel();
        userModelExpected.read((Reader)new StringReader(userModelExpectedRdf), null, "N3");
        Model additionsModel = fileModel.difference(backupModel);
        Model retractionsModel = backupModel.difference(fileModel);
        RDFFilesLoader.removeChangesThatConflictWithUIEdits((Model)backupModel, (Model)userModel, (Model)additionsModel);
        RDFFilesLoader.removeChangesThatConflictWithUIEdits((Model)backupModel, (Model)userModel, (Model)retractionsModel);
        userModel.remove(retractionsModel);
        userModel.add(additionsModel);
        Assert.assertTrue((String)("expected: " + userModelExpected + " but was: " + userModel), (boolean)userModelExpected.isIsomorphicWith(userModel));
    }

    @Test
    public void testFirsttimeUpdateEmptyBackup() {
        String fileModelRdf = "@prefix rdfs: <" + RDFS.getURI() + "> .\n@prefix : <http://example.com/individual/> .\n:n1 rdfs:label \"fish 'n' chips\"@en-GB . \n:n1 rdfs:label \"fish and fries\"@en-US . \n:n2 rdfs:label \"tube\"@en-GB . \n:n2 rdfs:label \"Subway!\"@en-US . \n:n2 rdfs:label \"metrou\"@ro-RO . \n";
        String userModelRdf = "@prefix rdfs: <" + RDFS.getURI() + "> .\n@prefix : <http://example.com/individual/> .\n:n1 rdfs:label \"fish and chips\"@en-GB . \n:n2 rdfs:label \"tube\"@en-GB . \n:n2 rdfs:label \"subway\"@en-US . \n:n2 rdfs:label \"nooo\"@no-NO . \n";
        String userModelExpectedRdf = "@prefix rdfs: <" + RDFS.getURI() + "> .\n@prefix : <http://example.com/individual/> .\n:n1 rdfs:label \"fish and chips\"@en-GB . \n:n1 rdfs:label \"fish and fries\"@en-US . \n:n2 rdfs:label \"tube\"@en-GB . \n:n2 rdfs:label \"subway\"@en-US . \n:n2 rdfs:label \"metrou\"@ro-RO . \n:n2 rdfs:label \"nooo\"@no-NO . \n";
        Model fileModel = ModelFactory.createDefaultModel();
        fileModel.read((Reader)new StringReader(fileModelRdf), null, "N3");
        Model backupModel = ModelFactory.createDefaultModel();
        Model userModel = ModelFactory.createDefaultModel();
        userModel.read((Reader)new StringReader(userModelRdf), null, "N3");
        Model userModelExpected = ModelFactory.createDefaultModel();
        userModelExpected.read((Reader)new StringReader(userModelExpectedRdf), null, "N3");
        Model additionsModel = fileModel.difference(backupModel);
        Model retractionsModel = backupModel.difference(fileModel);
        RDFFilesLoader.removeChangesThatConflictWithUIEdits((Model)backupModel, (Model)userModel, (Model)additionsModel);
        RDFFilesLoader.removeChangesThatConflictWithUIEdits((Model)backupModel, (Model)userModel, (Model)retractionsModel);
        userModel.remove(retractionsModel);
        userModel.add(additionsModel);
        Assert.assertTrue((String)("expected: " + userModelExpected + " but was: " + userModel), (boolean)userModelExpected.isIsomorphicWith(userModel));
    }
}

