/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.permissions;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.Permission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBean;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DisplayByRolePermission
extends Permission {
    private static final Log log = LogFactory.getLog(DisplayByRolePermission.class);
    public static final String NAMESPACE = "java:" + DisplayByRolePermission.class.getName() + "#";
    private final String roleName;
    private final BaseResourceBean.RoleLevel roleLevel;

    public DisplayByRolePermission(String roleName, BaseResourceBean.RoleLevel roleLevel) {
        super(NAMESPACE + roleName);
        if (roleName == null) {
            throw new NullPointerException("role may not be null.");
        }
        if (roleLevel == null) {
            throw new NullPointerException("roleLevel may not be null.");
        }
        this.roleName = roleName;
        this.roleLevel = roleLevel;
    }

    @Override
    public boolean isAuthorized(RequestedAction whatToAuth) {
        boolean result = whatToAuth instanceof DisplayDataProperty ? this.isAuthorized((DisplayDataProperty)whatToAuth) : (whatToAuth instanceof DisplayObjectProperty ? this.isAuthorized((DisplayObjectProperty)whatToAuth) : (whatToAuth instanceof DisplayDataPropertyStatement ? this.isAuthorized((DisplayDataPropertyStatement)whatToAuth) : (whatToAuth instanceof DisplayObjectPropertyStatement ? this.isAuthorized((DisplayObjectPropertyStatement)whatToAuth) : false)));
        if (result) {
            log.debug((Object)(this + " authorizes " + whatToAuth));
        } else {
            log.debug((Object)(this + " does not authorize " + whatToAuth));
        }
        return result;
    }

    private boolean isAuthorized(DisplayDataProperty action) {
        String predicateUri = action.getDataProperty().getURI();
        return this.canDisplayPredicate(new Property(predicateUri));
    }

    private boolean isAuthorized(DisplayObjectProperty action) {
        return this.canDisplayPredicate(action.getObjectProperty());
    }

    private boolean isAuthorized(DisplayDataPropertyStatement action) {
        DataPropertyStatement stmt = action.getDataPropertyStatement();
        String subjectUri = stmt.getIndividualURI();
        String predicateUri = stmt.getDatapropURI();
        return this.canDisplayResource(subjectUri) && this.canDisplayPredicate(new Property(predicateUri));
    }

    private boolean isAuthorized(DisplayObjectPropertyStatement action) {
        String subjectUri = action.getSubjectUri();
        String objectUri = action.getObjectUri();
        ObjectProperty op = action.getProperty();
        return this.canDisplayResource(subjectUri) && this.canDisplayPredicate(op) && this.canDisplayResource(objectUri);
    }

    private boolean canDisplayResource(String resourceUri) {
        return PropertyRestrictionBean.getBean().canDisplayResource(resourceUri, this.roleLevel);
    }

    private boolean canDisplayPredicate(Property predicate) {
        return PropertyRestrictionBean.getBean().canDisplayPredicate(predicate, this.roleLevel);
    }

    @Override
    public String toString() {
        return "DisplayByRolePermission['" + this.roleName + "']";
    }
}

