/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import java.util.Comparator;

public class ObjectPropertyStatementImpl
implements ObjectPropertyStatement {
    private String subjectURI = null;
    private Individual subject = null;
    private String objectURI = null;
    private Individual object = null;
    private String propertyURI = null;
    private ObjectProperty property = null;
    private boolean subjectOriented = true;

    public ObjectPropertyStatementImpl() {
    }

    public ObjectPropertyStatementImpl(String subjectUri, String propertyUri, String objectUri) {
        this.subjectURI = subjectUri;
        this.propertyURI = propertyUri;
        this.objectURI = objectUri;
    }

    @Override
    public String toString() {
        String prop = this.getProperty() != null ? this.getProperty().getDomainPublic() : "by propURI" + this.getPropertyURI();
        String ran = this.getObject() != null ? this.getObject().getName() : "objectURI:" + this.getObjectURI();
        String dom = this.getSubject() != null ? this.getSubject().getName() : "subjectURI:" + this.getSubjectURI();
        return "Object Property Statements: " + dom + " " + prop + " to " + ran + " ";
    }

    @Override
    public String getSubjectURI() {
        return this.subjectURI;
    }

    @Override
    public void setSubjectURI(String subjectURI) {
        this.subjectURI = subjectURI;
    }

    @Override
    public String getObjectURI() {
        return this.objectURI;
    }

    @Override
    public void setObjectURI(String objectURI) {
        this.objectURI = objectURI;
    }

    @Override
    public Individual getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(Individual subject) {
        this.subject = subject;
        if (subject == null || subject.isAnonymous()) {
            this.setSubjectURI(null);
        } else {
            this.setSubjectURI(subject.getURI());
        }
    }

    @Override
    public ObjectProperty getProperty() {
        return this.property;
    }

    @Override
    public void setProperty(ObjectProperty property) {
        if (property != null) {
            this.setPropertyURI(property.getURI());
        } else {
            this.setPropertyURI(null);
        }
        this.property = property;
    }

    @Override
    public Individual getObject() {
        return this.object;
    }

    @Override
    public void setObject(Individual object) {
        this.object = object;
        if (object == null || object.isAnonymous()) {
            this.setObjectURI(null);
        } else {
            this.setObjectURI(object.getURI());
        }
    }

    @Override
    public String getPropertyURI() {
        return this.propertyURI;
    }

    @Override
    public void setPropertyURI(String URI) {
        this.propertyURI = URI;
    }

    @Override
    public PropertyInstance toPropertyInstance() {
        PropertyInstance pi = new PropertyInstance();
        pi.setPropertyURI(this.propertyURI);
        pi.setSubjectEntURI(this.subjectURI);
        pi.setObjectEntURI(this.objectURI);
        return pi;
    }

    public static class DisplayComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Individual ent1 = ((ObjectPropertyStatement)o1).getSubject();
            Individual ent2 = ((ObjectPropertyStatement)o2).getSubject();
            return ent1.getName().compareTo(ent2.getName());
        }
    }
}

