/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonArrayProducer;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetEntitiesByVClass
extends JsonArrayProducer {
    private static final Log log = LogFactory.getLog(GetEntitiesByVClass.class);

    protected GetEntitiesByVClass(VitroRequest vreq) {
        super(vreq);
    }

    @Override
    protected ArrayNode process() throws ServletException {
        int count;
        log.debug((Object)"in getEntitiesByVClass()");
        String vclassURI = this.vreq.getParameter("vclassURI");
        WebappDaoFactory daos = this.vreq.getUnfilteredWebappDaoFactory();
        if (vclassURI == null) {
            throw new ServletException("getEntitiesByVClass(): no value for 'vclassURI' found in the HTTP request");
        }
        VClass vclass = daos.getVClassDao().getVClassByURI(vclassURI);
        if (vclass == null) {
            throw new ServletException("getEntitiesByVClass(): could not find vclass for uri '" + vclassURI + "'");
        }
        List<Individual> entsInVClass = daos.getIndividualDao().getIndividualsByVClass(vclass);
        if (entsInVClass == null) {
            throw new ServletException("getEntitiesByVClass(): null List<Individual> retruned by getIndividualsByVClass() for " + vclassURI);
        }
        int numberOfEntsInVClass = entsInVClass.size();
        List<Object> entsToReturn = new ArrayList(256);
        String requestHash = null;
        boolean more = false;
        if (entsInVClass.size() > 256) {
            more = true;
            HttpSession session = this.vreq.getSession(true);
            requestHash = Integer.toString((vclassURI + System.currentTimeMillis()).hashCode());
            session.setAttribute(requestHash, entsInVClass);
            ListIterator<Individual> entsFromVclass = entsInVClass.listIterator();
            for (count = 0; entsFromVclass.hasNext() && count < 256; ++count) {
                entsToReturn.add(entsFromVclass.next());
                entsFromVclass.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getEntitiesByVClass(): Creating reply with continue token, found " + numberOfEntsInVClass + " Individuals"));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getEntitiesByVClass(): sending " + numberOfEntsInVClass + " Individuals without continue token"));
            }
            entsToReturn = entsInVClass;
            count = entsToReturn.size();
        }
        ArrayNode ja = this.individualsToJson(entsToReturn);
        if (more) {
            ObjectNode obj = JsonNodeFactory.instance.objectNode();
            obj.put("resultGroup", "true");
            obj.put("size", count);
            obj.put("total", numberOfEntsInVClass);
            StringBuffer nextUrlStr = this.vreq.getRequestURL();
            nextUrlStr.append("?").append("getEntitiesByVClass").append("=1&").append("resultKey=").append(requestHash);
            obj.put("nextUrl", nextUrlStr.toString());
            ja.add((JsonNode)obj);
        }
        log.debug((Object)"done with getEntitiesByVClass()");
        return ja;
    }
}

