/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.BaseFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.ObjectPropertyStatementFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jga.algorithms.Filter;

public class ObjectPropertyStatementDaoFiltering
extends BaseFiltering
implements ObjectPropertyStatementDao {
    final ObjectPropertyStatementDao innerObjectPropertyStatementDao;
    final VitroFilters filters;

    public ObjectPropertyStatementDaoFiltering(ObjectPropertyStatementDao objectPropertyStatementDao, VitroFilters filters) {
        this.innerObjectPropertyStatementDao = objectPropertyStatementDao;
        this.filters = filters;
    }

    @Override
    public void deleteObjectPropertyStatement(ObjectPropertyStatement objPropertyStmt) {
        this.innerObjectPropertyStatementDao.deleteObjectPropertyStatement(objPropertyStmt);
    }

    private List<ObjectPropertyStatement> filterAndWrapList(List<ObjectPropertyStatement> list) {
        if (list != null) {
            this.innerObjectPropertyStatementDao.resolveAsFauxPropertyStatements(list);
            ArrayList ctemp = new ArrayList();
            Filter.filter(list, this.filters.getObjectPropertyStatementFilter(), ctemp);
            ArrayList<ObjectPropertyStatement> cout = new ArrayList<ObjectPropertyStatement>(list.size());
            for (ObjectPropertyStatement stmt : ctemp) {
                cout.add(new ObjectPropertyStatementFiltering(stmt, this.filters));
            }
            return cout;
        }
        return null;
    }

    @Override
    public Individual fillExistingObjectPropertyStatements(Individual entity) {
        Individual ind = this.innerObjectPropertyStatementDao.fillExistingObjectPropertyStatements(entity);
        if (ind == null) {
            return null;
        }
        ind.setObjectPropertyStatements(this.filterAndWrapList(ind.getObjectPropertyStatements()));
        return ind;
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(ObjectProperty objectProperty) {
        return this.filterAndWrapList(this.innerObjectPropertyStatementDao.getObjectPropertyStatements(objectProperty));
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(ObjectProperty objectProperty, int startIndex, int endIndex) {
        return this.filterAndWrapList(this.innerObjectPropertyStatementDao.getObjectPropertyStatements(objectProperty, startIndex, endIndex));
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(ObjectPropertyStatement objPropertyStmt) {
        return this.filterAndWrapList(this.innerObjectPropertyStatementDao.getObjectPropertyStatements(objPropertyStmt));
    }

    @Override
    public int insertNewObjectPropertyStatement(ObjectPropertyStatement objPropertyStmt) {
        return this.innerObjectPropertyStatementDao.insertNewObjectPropertyStatement(objPropertyStmt);
    }

    @Override
    public List<Map<String, String>> getObjectPropertyStatementsForIndividualByProperty(String subjectUri, String propertyUri, String objectKey, String domainUri, String rangeUri, String query, Set<String> queryStrings, String sortDirection) {
        List<Map<String, String>> data = this.innerObjectPropertyStatementDao.getObjectPropertyStatementsForIndividualByProperty(subjectUri, propertyUri, objectKey, domainUri, rangeUri, query, queryStrings, sortDirection);
        LinkedHashMap<ObjectPropertyStatementImpl, Map<String, String>> stmtsToData = new LinkedHashMap<ObjectPropertyStatementImpl, Map<String, String>>(data.size());
        for (Map<String, String> map : data) {
            String objectUri = map.get(objectKey);
            ObjectPropertyStatementImpl statement = new ObjectPropertyStatementImpl(subjectUri, propertyUri, objectUri);
            ObjectProperty op = new ObjectProperty();
            op.setURI(propertyUri);
            op.setDomainVClassURI(domainUri);
            op.setRangeVClassURI(rangeUri);
            statement.setProperty(op);
            stmtsToData.put(statement, map);
        }
        ArrayList<ObjectPropertyStatement> stmtList = new ArrayList<ObjectPropertyStatement>(stmtsToData.keySet());
        List<ObjectPropertyStatement> filteredStatements = this.filterAndWrapList(stmtList);
        ArrayList<Map<String, String>> filteredData = new ArrayList<Map<String, String>>(filteredStatements.size());
        for (ObjectPropertyStatement ops : filteredStatements) {
            if (ops instanceof ObjectPropertyStatementFiltering) {
                ops = ((ObjectPropertyStatementFiltering)ops).innerStmt;
            }
            filteredData.add((Map)stmtsToData.get(ops));
        }
        return filteredData;
    }

    @Override
    public Map<String, String> getMostSpecificTypesInClassgroupsForIndividual(String subjectUri) {
        return this.innerObjectPropertyStatementDao.getMostSpecificTypesInClassgroupsForIndividual(subjectUri);
    }

    @Override
    public void resolveAsFauxPropertyStatements(List<ObjectPropertyStatement> list) {
        this.innerObjectPropertyStatementDao.resolveAsFauxPropertyStatements(list);
    }
}

