/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.BaseEditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import freemarker.template.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.ResourceFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeWithPrecisionVTwo
extends BaseEditElementVTwo {
    VitroVocabulary.Precision minimumPrecision;
    VitroVocabulary.Precision displayRequiredLevel;
    VitroVocabulary.Precision DEFAULT_MIN_PRECISION = VitroVocabulary.Precision.DAY;
    VitroVocabulary.Precision DEFAULT_DISPLAY_LEVEL = VitroVocabulary.Precision.DAY;
    VitroVocabulary.Precision[] precisions = VitroVocabulary.Precision.values();
    protected static final String BLANK_SENTINEL = ">SUBMITTED VALUE WAS BLANK<";
    private static final Log log = LogFactory.getLog(DateTimeWithPrecisionVTwo.class);
    protected String TEMPLATE_NAME = "dateTimeWithPrecision.ftl";
    static final String NON_INTEGER_YEAR = "must enter a valid year";
    static final String NON_INTEGER_MONTH = "must enter a valid month";
    static final String NON_INTEGER_DAY = "must enter a valid day";
    static final String NON_INTEGER_HOUR = "must enter a valid hour";
    static final String NON_INTEGER_MINUTE = "must enter a valid minute";
    static final String NON_INTEGER_SECOND = "must enter a valid second";

    public DateTimeWithPrecisionVTwo(FieldVTwo field) {
        super(field);
        this.minimumPrecision = this.DEFAULT_MIN_PRECISION;
        this.displayRequiredLevel = this.DEFAULT_DISPLAY_LEVEL;
    }

    public DateTimeWithPrecisionVTwo(FieldVTwo field, VitroVocabulary.Precision minimumPrecision) {
        this(field);
        this.minimumPrecision = minimumPrecision != null ? minimumPrecision : this.DEFAULT_MIN_PRECISION;
        this.displayRequiredLevel = this.minimumPrecision;
    }

    public DateTimeWithPrecisionVTwo(FieldVTwo field, String minimumPrecisionURI, String displayRequiredLevelUri) {
        this(field);
        this.minimumPrecision = DateTimeWithPrecisionVTwo.toPrecision(minimumPrecisionURI);
        if (this.minimumPrecision == null) {
            throw new IllegalArgumentException(minimumPrecisionURI + " is not a valid precision for minimumPrecision, see VitroVocabulary.Precision");
        }
        this.displayRequiredLevel = DateTimeWithPrecisionVTwo.toPrecision(displayRequiredLevelUri);
        if (this.displayRequiredLevel == null) {
            throw new IllegalArgumentException(displayRequiredLevelUri + " is not a valid precision for displayRequiredLevel, see VitroVocabulary.Precision");
        }
    }

    private String getFieldName() {
        return this.field.getName();
    }

    @Override
    public String draw(String fieldName, EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub, Configuration fmConfig) {
        Map map = this.getMapForTemplate(editConfig, editSub);
        return this.merge(fmConfig, this.TEMPLATE_NAME, map);
    }

    @Override
    public Map getMapForTemplate(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fieldName", this.getFieldName());
        this.addPrecisionConstants(map);
        map.put("minimumPrecision", this.minimumPrecision.uri());
        map.put("requiredLevel", this.displayRequiredLevel.uri());
        String precisionUri = this.getPrecision(editConfig, editSub);
        VitroVocabulary.Precision existingPrec = DateTimeWithPrecisionVTwo.toPrecision(precisionUri);
        if (precisionUri != null && !"".equals(precisionUri) && existingPrec == null && !BLANK_SENTINEL.equals(precisionUri)) {
            log.debug((Object)("field " + this.getFieldName() + ": existing precision uri was '" + precisionUri + "' but could not convert to Precision object"));
        }
        if (precisionUri == null || precisionUri.isEmpty() || existingPrec == null) {
            map.put("existingPrecision", "");
            DateTime value = this.getTimeValue(editConfig, editSub);
            if (value != null) {
                log.debug((Object)("Unexpected state: Precision for " + this.getFieldName() + " was '" + precisionUri + "' but date time was " + value));
            }
            map.put("year", "");
            map.put("month", "");
            map.put("day", "");
            map.put("hour", "");
            map.put("minute", "");
            map.put("second", "");
        } else if (VitroVocabulary.Precision.NONE.uri().equals(precisionUri)) {
            map.put("existingPrecision", precisionUri);
            map.put("year", "");
            map.put("month", "");
            map.put("day", "");
            map.put("hour", "");
            map.put("minute", "");
            map.put("second", "");
        } else {
            map.put("existingPrecision", precisionUri);
            DateTime value = this.getTimeValue(editConfig, editSub);
            if (value == null) {
                log.error((Object)("Field " + this.getFieldName() + " has precision " + precisionUri + " but the date time value is null "));
                map.put("year", "");
                map.put("month", "");
                map.put("day", "");
                map.put("hour", "");
                map.put("minute", "");
                map.put("second", "");
            } else {
                if (existingPrec.ordinal() >= VitroVocabulary.Precision.SECOND.ordinal()) {
                    map.put("second", Integer.toString(value.getSecondOfMinute()));
                } else {
                    map.put("second", "");
                }
                if (existingPrec.ordinal() >= VitroVocabulary.Precision.MINUTE.ordinal()) {
                    map.put("minute", Integer.toString(value.getMinuteOfHour()));
                } else {
                    map.put("minute", "");
                }
                if (existingPrec.ordinal() >= VitroVocabulary.Precision.HOUR.ordinal()) {
                    map.put("hour", Integer.toString(value.getHourOfDay()));
                } else {
                    map.put("hour", "");
                }
                if (existingPrec.ordinal() >= VitroVocabulary.Precision.DAY.ordinal()) {
                    map.put("day", Integer.toString(value.getDayOfMonth()));
                } else {
                    map.put("day", "");
                }
                if (existingPrec.ordinal() >= VitroVocabulary.Precision.MONTH.ordinal()) {
                    map.put("month", Integer.toString(value.getMonthOfYear()));
                } else {
                    map.put("month", "");
                }
                if (existingPrec.ordinal() >= VitroVocabulary.Precision.YEAR.ordinal()) {
                    map.put("year", Integer.toString(value.getYear()));
                } else {
                    map.put("year", "");
                }
            }
        }
        return map;
    }

    private void addPrecisionConstants(Map<String, Object> map) {
        HashMap<String, String> constants = new HashMap<String, String>();
        for (VitroVocabulary.Precision pc : VitroVocabulary.Precision.values()) {
            constants.put(pc.name().toLowerCase(), pc.uri());
        }
        map.put("precisionConstants", constants);
    }

    private String getPrecision(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        List<String> submittedPrecisionURI;
        if (editSub != null && (submittedPrecisionURI = editSub.getUrisFromForm().get(this.getPrecisionVariableName())) != null && submittedPrecisionURI.size() > 0 && submittedPrecisionURI.get(0) != null) {
            return submittedPrecisionURI.get(0);
        }
        List<String> existingPrecisionURI = editConfig.getUrisInScope().get(this.getPrecisionVariableName());
        if (existingPrecisionURI != null && existingPrecisionURI.size() > 0 && existingPrecisionURI.get(0) != null) {
            return existingPrecisionURI.get(0);
        }
        return null;
    }

    private DateTime getTimeValue(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        List<Literal> submittedValue;
        if (editSub != null && (submittedValue = editSub.getLiteralsFromForm().get(this.getValueVariableName())) != null && submittedValue.size() > 0 && submittedValue.get(0) != null) {
            return new DateTime((Object)submittedValue.get(0).getLexicalForm());
        }
        List<Literal> dtValue = editConfig.getLiteralsInScope().get(this.getValueVariableName());
        if (dtValue != null && dtValue.size() > 0 && dtValue.get(0) != null) {
            return new DateTime((Object)dtValue.get(0).getLexicalForm());
        }
        return null;
    }

    @Override
    public Map<String, List<Literal>> getLiterals(String fieldName, EditConfigurationVTwo editConfig, Map<String, String[]> queryParameters) {
        HashMap<String, List<Literal>> literalMap = new HashMap<String, List<Literal>>();
        Literal datetime = this.getDateTime(queryParameters);
        ArrayList<Literal> literals = new ArrayList<Literal>();
        literals.add(datetime);
        literalMap.put(fieldName + "-value", literals);
        return literalMap;
    }

    protected Literal getDateTime(Map<String, String[]> queryParameters) {
        Integer second;
        Integer minute;
        Integer hour;
        Integer day;
        String submittedPrec = BLANK_SENTINEL;
        try {
            submittedPrec = this.getSubmittedPrecision(queryParameters);
        }
        catch (Exception e) {
            log.error((Object)"could not get submitted precsion", (Throwable)e);
        }
        if (BLANK_SENTINEL.equals(submittedPrec)) {
            return null;
        }
        Integer year = this.parseToInt(this.getFieldName() + "-year", queryParameters);
        if (year == null) {
            return null;
        }
        Integer month = this.parseToInt(this.getFieldName() + "-month", queryParameters);
        if (month == null || month == 0) {
            month = 1;
        }
        if ((day = this.parseToInt(this.getFieldName() + "-day", queryParameters)) == null || day == 0) {
            day = 1;
        }
        if ((hour = this.parseToInt(this.getFieldName() + "-hour", queryParameters)) == null) {
            hour = 0;
        }
        if ((minute = this.parseToInt(this.getFieldName() + "-minute", queryParameters)) == null) {
            minute = 0;
        }
        if ((second = this.parseToInt(this.getFieldName() + "-second", queryParameters)) == null) {
            second = 0;
        }
        DateTime value = new DateTime(year.intValue(), month.intValue(), day.intValue(), hour.intValue(), minute.intValue(), second.intValue(), 0);
        return ResourceFactory.createTypedLiteral((String)ISODateTimeFormat.dateHourMinuteSecond().print((ReadableInstant)value), (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    @Override
    public Map<String, List<String>> getURIs(String fieldName, EditConfigurationVTwo editConfig, Map<String, String[]> queryParameters) {
        String precisionUri;
        try {
            precisionUri = this.getSubmittedPrecision(queryParameters);
        }
        catch (Exception e) {
            log.error((Object)"getURIs() should only be called on input that passed getValidationErrors()");
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> uriMap = new HashMap<String, List<String>>();
        if (precisionUri != null) {
            ArrayList<String> uris = new ArrayList<String>();
            uris.add(precisionUri);
            uriMap.put(fieldName + "-precision", uris);
        }
        return uriMap;
    }

    protected String getSubmittedPrecision(Map<String, String[]> queryParameters) throws Exception {
        Integer year = this.parseToInt(this.getFieldName() + "-year", queryParameters);
        Integer month = this.parseToInt(this.getFieldName() + "-month", queryParameters);
        Integer day = this.parseToInt(this.getFieldName() + "-day", queryParameters);
        Integer hour = this.parseToInt(this.getFieldName() + "-hour", queryParameters);
        Integer minute = this.parseToInt(this.getFieldName() + "-minute", queryParameters);
        Integer second = this.parseToInt(this.getFieldName() + "-second", queryParameters);
        Integer[] values = new Integer[]{year, month, day, hour, minute, second};
        int indexOfFirstNull = -1;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            indexOfFirstNull = i;
            break;
        }
        if (indexOfFirstNull == 0) {
            return BLANK_SENTINEL;
        }
        if (indexOfFirstNull == -1) {
            return VitroVocabulary.Precision.SECOND.uri();
        }
        boolean nonNullAfterFirstNull = false;
        for (int i = 0; i < values.length; ++i) {
            if (i <= indexOfFirstNull || values[i] == null) continue;
            nonNullAfterFirstNull = true;
            break;
        }
        if (nonNullAfterFirstNull) {
            throw new Exception("Invalid date-time value. When creating a date-time value, there cannot be gaps between any of the selected fields.");
        }
        return this.precisions[indexOfFirstNull].uri();
    }

    @Override
    public Map<String, String> getValidationMessages(String fieldName, EditConfigurationVTwo editConfig, Map<String, String[]> queryParameters) {
        String[] names;
        HashMap<String, String> errorMsgMap = new HashMap<String, String>();
        for (String name : names = new String[]{"year", "month", "day", "hour", "minute", "second", "precision"}) {
            if (this.hasNoneOrSingle(fieldName + "-" + name, queryParameters)) continue;
            errorMsgMap.put(fieldName + "-" + name, "must have only one value for " + name);
        }
        String precisionURI = null;
        try {
            precisionURI = this.getSubmittedPrecision(queryParameters);
        }
        catch (Exception ex) {
            errorMsgMap.put(fieldName, ex.getMessage());
            return errorMsgMap;
        }
        errorMsgMap.putAll(this.checkDate(precisionURI, queryParameters));
        return errorMsgMap;
    }

    private Map<String, String> checkDate(String precisionURI, Map<String, String[]> qp) {
        Integer second;
        Integer minute;
        Integer hour;
        Integer day;
        Integer month;
        Integer year;
        if (precisionURI == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        if (precisionURI.equals(VitroVocabulary.Precision.YEAR.uri())) {
            if (!this.canParseToNumber(this.getFieldName() + "-year", qp)) {
                errors.put(this.getFieldName() + "-year", NON_INTEGER_YEAR);
            }
        } else if (precisionURI.equals(VitroVocabulary.Precision.MONTH.uri())) {
            if (!this.canParseToNumber(this.getFieldName() + "-year", qp)) {
                errors.put(this.getFieldName() + "-year", NON_INTEGER_YEAR);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-month", qp)) {
                errors.put(this.getFieldName() + "-month", NON_INTEGER_MONTH);
            }
        } else if (precisionURI.equals(VitroVocabulary.Precision.DAY.uri())) {
            if (!this.canParseToNumber(this.getFieldName() + "-year", qp)) {
                errors.put(this.getFieldName() + "-year", NON_INTEGER_YEAR);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-month", qp)) {
                errors.put(this.getFieldName() + "-month", NON_INTEGER_MONTH);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-day", qp)) {
                errors.put(this.getFieldName() + "-day", NON_INTEGER_DAY);
            }
        } else if (precisionURI.equals(VitroVocabulary.Precision.HOUR.uri())) {
            if (!this.canParseToNumber(this.getFieldName() + "-year", qp)) {
                errors.put(this.getFieldName() + "-year", NON_INTEGER_YEAR);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-month", qp)) {
                errors.put(this.getFieldName() + "-month", NON_INTEGER_MONTH);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-day", qp)) {
                errors.put(this.getFieldName() + "-day", NON_INTEGER_DAY);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-hour", qp)) {
                errors.put(this.getFieldName() + "-hour", NON_INTEGER_HOUR);
            }
        } else if (precisionURI.equals(VitroVocabulary.Precision.MINUTE.uri())) {
            if (!this.canParseToNumber(this.getFieldName() + "-year", qp)) {
                errors.put(this.getFieldName() + "-year", NON_INTEGER_YEAR);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-month", qp)) {
                errors.put(this.getFieldName() + "-month", NON_INTEGER_MONTH);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-day", qp)) {
                errors.put(this.getFieldName() + "-day", NON_INTEGER_DAY);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-hour", qp)) {
                errors.put(this.getFieldName() + "-hour", NON_INTEGER_HOUR);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-minute", qp)) {
                errors.put(this.getFieldName() + "-minute", NON_INTEGER_HOUR);
            }
        } else if (precisionURI.equals(VitroVocabulary.Precision.SECOND.uri())) {
            if (!this.canParseToNumber(this.getFieldName() + "-year", qp)) {
                errors.put(this.getFieldName() + "-year", NON_INTEGER_YEAR);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-month", qp)) {
                errors.put(this.getFieldName() + "-month", NON_INTEGER_MONTH);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-day", qp)) {
                errors.put(this.getFieldName() + "-day", NON_INTEGER_DAY);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-hour", qp)) {
                errors.put(this.getFieldName() + "-hour", NON_INTEGER_HOUR);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-minute", qp)) {
                errors.put(this.getFieldName() + "-minute", NON_INTEGER_HOUR);
            }
            if (!this.canParseToNumber(this.getFieldName() + "-second", qp)) {
                errors.put(this.getFieldName() + "-second", NON_INTEGER_SECOND);
            }
        }
        if ((year = this.parseToInt(this.getFieldName() + "-year", qp)) == null) {
            year = 1999;
        }
        if ((month = this.parseToInt(this.getFieldName() + "-month", qp)) == null) {
            month = 1;
        }
        if ((day = this.parseToInt(this.getFieldName() + "-day", qp)) == null) {
            day = 1;
        }
        if ((hour = this.parseToInt(this.getFieldName() + "-hour", qp)) == null) {
            hour = 0;
        }
        if ((minute = this.parseToInt(this.getFieldName() + "-minute", qp)) == null) {
            minute = 0;
        }
        if ((second = this.parseToInt(this.getFieldName() + "-second", qp)) == null) {
            second = 0;
        }
        DateTime dateTime = new DateTime((Object)"1970-01-01T00:00:00Z");
        try {
            dateTime = dateTime.withYear(year.intValue());
        }
        catch (IllegalArgumentException iae) {
            errors.put(this.getFieldName() + "-year", iae.getLocalizedMessage());
        }
        try {
            dateTime = dateTime.withMonthOfYear(month.intValue());
        }
        catch (IllegalArgumentException iae) {
            errors.put(this.getFieldName() + "-month", iae.getLocalizedMessage());
        }
        try {
            dateTime = dateTime.withDayOfMonth(day.intValue());
        }
        catch (IllegalArgumentException iae) {
            errors.put(this.getFieldName() + "-day", iae.getLocalizedMessage());
        }
        try {
            dateTime = dateTime.withHourOfDay(hour.intValue());
        }
        catch (IllegalArgumentException iae) {
            errors.put(this.getFieldName() + "-hour", iae.getLocalizedMessage());
        }
        try {
            dateTime = dateTime.withSecondOfMinute(second.intValue());
        }
        catch (IllegalArgumentException iae) {
            errors.put(this.getFieldName() + "-second", iae.getLocalizedMessage());
        }
        return errors;
    }

    private boolean fieldMatchesPattern(String fieldName, Map<String, String[]> queryParameters, Pattern pattern) {
        String[] varg = queryParameters.get(fieldName);
        if (varg == null || varg.length != 1 || varg[0] == null) {
            return false;
        }
        String value = varg[0];
        Matcher match = pattern.matcher(value);
        return match.matches();
    }

    private boolean emptyOrBlank(String key, Map<String, String[]> queryParameters) {
        String[] vt = queryParameters.get(key);
        return vt == null || vt.length == 0 || vt[0] == null || vt[0].length() == 0;
    }

    private boolean canParseToNumber(String key, Map<String, String[]> queryParameters) {
        Integer out = null;
        try {
            String[] vt = queryParameters.get(key);
            if (vt == null || vt.length == 0 || vt[0] == null) {
                return false;
            }
            out = Integer.parseInt(vt[0]);
            return true;
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException iex) {
            out = null;
            return false;
        }
    }

    private Integer parseToInt(String key, Map<String, String[]> queryParameters) {
        Integer out = null;
        try {
            String[] vt = queryParameters.get(key);
            out = vt == null || vt.length == 0 || vt[0] == null ? null : Integer.valueOf(Integer.parseInt(vt[0]));
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException iex) {
            out = null;
        }
        return out;
    }

    public VitroVocabulary.Precision getRequiredMinimumPrecision() {
        return this.minimumPrecision;
    }

    public void setRequiredMinimumPrecision(VitroVocabulary.Precision requiredMinimumPrecision) {
        this.minimumPrecision = requiredMinimumPrecision;
    }

    public static VitroVocabulary.Precision toPrecision(String precisionUri) {
        for (VitroVocabulary.Precision precision : VitroVocabulary.Precision.values()) {
            if (!precision.uri().equals(precisionUri)) continue;
            return precision;
        }
        return null;
    }

    public String getValueVariableName() {
        return this.getFieldName() + "-value";
    }

    public String getPrecisionVariableName() {
        return this.getFieldName() + "-precision";
    }
}

