/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.vocabulary.OWL;

public class ChildVClassesWithParent
implements FieldOptions {
    private static final String LEFT_BLANK = "";
    String fieldName;
    String classUri;
    String defaultOptionLabel = null;

    public ChildVClassesWithParent(String classUri) throws Exception {
        if (classUri == null || classUri.equals(LEFT_BLANK)) {
            throw new Exception("vclassUri not set");
        }
        this.classUri = classUri;
    }

    public ChildVClassesWithParent setDefaultOption(String label) {
        this.defaultOptionLabel = label;
        return this;
    }

    @Override
    public Map<String, String> getOptions(EditConfigurationVTwo editConfig, String fieldName, WebappDaoFactory wDaoFact, I18nBundle i18n) throws Exception {
        List<String> subClassList;
        VClassDao vclassDao;
        VClass rdfClass;
        LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)this.defaultOptionLabel)) {
            optionsMap.put(LEFT_BLANK, this.defaultOptionLabel);
        }
        if ((rdfClass = (vclassDao = wDaoFact.getVClassDao()).getVClassByURI(this.classUri)) != null && !OWL.Nothing.getURI().equals(this.classUri)) {
            optionsMap.put(this.classUri, rdfClass.getName().trim());
        }
        if ((subClassList = vclassDao.getAllSubClassURIs(this.classUri)) != null && subClassList.size() > 0) {
            for (String subClassUri : subClassList) {
                rdfClass = vclassDao.getVClassByURI(subClassUri);
                if (rdfClass == null || OWL.Nothing.getURI().equals(subClassUri)) continue;
                optionsMap.put(subClassUri, rdfClass.getName().trim());
            }
        }
        return optionsMap;
    }

    @Override
    public Comparator<String[]> getCustomComparator() {
        return null;
    }
}

