/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebFilter(filterName="JSession Strip Filter", urlPatterns={"/*"})
public class JSessionStripFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private static final Log log = LogFactory.getLog((String)JSessionStripFilter.class.getName());
    public static String USING_JSESSION_STRIP = "usingJsessionStrip";

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info((Object)"Filtering: no jsessionids will be generated.");
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse hResponse = (HttpServletResponse)response;
        HttpServletRequest hRequest = (HttpServletRequest)request;
        hRequest.setAttribute(USING_JSESSION_STRIP, (Object)"true");
        if (hResponse.isCommitted()) {
            log.error((Object)"response is comitted cannot forward  (check you haven't done anything to the response (ie, written to it) before here)");
            return;
        }
        chain.doFilter((ServletRequest)hRequest, (ServletResponse)new StripSessionIdWrapper(hResponse));
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public class StripSessionIdWrapper
    extends HttpServletResponseWrapper {
        public StripSessionIdWrapper(HttpServletResponse response) {
            super(response);
        }

        public String encodeRedirectUrl(String url) {
            return url;
        }

        public String encodeRedirectURL(String url) {
            return url;
        }

        public String encodeUrl(String url) {
            return url;
        }

        public String encodeURL(String url) {
            return url;
        }

        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
        }
    }
}

