/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchQuery;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.QueryConverter;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class ESDeleter {
    private static final Log log = LogFactory.getLog(ESDeleter.class);
    private final String baseUrl;

    public ESDeleter(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void deleteByIds(Collection<String> ids) throws SearchEngineException {
        for (String id : ids) {
            this.deleteById(id);
        }
    }

    private void deleteById(String id) throws SearchEngineException {
        try {
            String url = this.baseUrl + "/_doc/" + URLEncoder.encode(id, "UTF8");
            Response response = Request.Delete((String)url).execute();
            String string = response.returnContent().asString();
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() != 404) {
                throw new SearchEngineException("Failed to delete Elasticsearch document " + id, e);
            }
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to delete Elasticsearch document " + id, e);
        }
    }

    public void deleteByQuery(String queryString) throws SearchEngineException {
        String url = this.baseUrl + "/_delete_by_query";
        SearchQuery query = new BaseSearchQuery().setQuery(queryString);
        String queryJson = new QueryConverter(query).asString();
        try {
            Response response = Request.Post((String)url).bodyString(queryJson, ContentType.APPLICATION_JSON).execute();
            BaseResponseHandler handler = new BaseResponseHandler();
            response.handleResponse((ResponseHandler)handler);
            if (handler.getStatusCode() >= 400) {
                log.warn((Object)String.format("Failed to delete Elasticsearch documents by query: %s, %d - %s\n%s", queryString, handler.getStatusCode(), handler.getReasonPhrase(), handler.getContentString()));
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete Elasticsearch documents by query " + queryString, e);
        }
    }

    private class BaseResponseHandler
    implements ResponseHandler<Object> {
        private int statusCode;
        private String reasonPhrase;
        private Map<String, List<String>> headers;
        private String contentString;

        private BaseResponseHandler() {
        }

        public Object handleResponse(HttpResponse innerResponse) throws IOException {
            StatusLine statusLine = innerResponse.getStatusLine();
            this.statusCode = statusLine.getStatusCode();
            this.reasonPhrase = statusLine.getReasonPhrase();
            this.headers = new HashMap<String, List<String>>();
            for (Header header : innerResponse.getAllHeaders()) {
                String name = header.getName();
                if (!this.headers.containsKey(name)) {
                    this.headers.put(name, new ArrayList());
                }
                this.headers.get(name).add(header.getValue());
            }
            HttpEntity entity = innerResponse.getEntity();
            this.contentString = entity == null ? "" : EntityUtils.toString((HttpEntity)entity);
            return "";
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public String getContentString() {
            return this.contentString;
        }
    }
}

