/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.developer.listeners;

import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class DeveloperDisabledModelChangeListener
implements ModelChangedListener {
    private final ModelChangedListener inner;
    private final Key disablingKey;

    public DeveloperDisabledModelChangeListener(ModelChangedListener inner, Key disablingKey) {
        this.inner = inner;
        this.disablingKey = disablingKey;
    }

    private boolean isEnabled() {
        return !DeveloperSettings.getInstance().getBoolean(this.disablingKey);
    }

    public void addedStatement(Statement s) {
        if (this.isEnabled()) {
            this.inner.addedStatement(s);
        }
    }

    public void addedStatements(Statement[] statements) {
        if (this.isEnabled()) {
            this.inner.addedStatements(statements);
        }
    }

    public void addedStatements(List<Statement> statements) {
        if (this.isEnabled()) {
            this.inner.addedStatements(statements);
        }
    }

    public void addedStatements(StmtIterator statements) {
        if (this.isEnabled()) {
            this.inner.addedStatements(statements);
        }
    }

    public void addedStatements(Model m) {
        if (this.isEnabled()) {
            this.inner.addedStatements(m);
        }
    }

    public void removedStatement(Statement s) {
        if (this.isEnabled()) {
            this.inner.removedStatement(s);
        }
    }

    public void removedStatements(Statement[] statements) {
        if (this.isEnabled()) {
            this.inner.removedStatements(statements);
        }
    }

    public void removedStatements(List<Statement> statements) {
        if (this.isEnabled()) {
            this.inner.removedStatements(statements);
        }
    }

    public void removedStatements(StmtIterator statements) {
        if (this.isEnabled()) {
            this.inner.removedStatements(statements);
        }
    }

    public void removedStatements(Model m) {
        if (this.isEnabled()) {
            this.inner.removedStatements(m);
        }
    }

    public void notifyEvent(Model m, Object event) {
        if (this.isEnabled()) {
            this.inner.notifyEvent(m, event);
        }
    }
}

