/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier.factory;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.IsRootUser;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.IsRootUserFactory;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class IsRootUserFactoryTest
extends AbstractTestClass {
    private static final String PLAIN_USER_URI = "http://userUri";
    private static final String ROOT_USER_URI = "http://rootUri";
    private WebappDaoFactoryStub wdf;
    private UserAccountsDaoStub uaDao;
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub req;
    private IsRootUserFactory factory;
    private IdentifierBundle actualIds;
    private IdentifierBundle expectedIds;

    @Before
    public void setup() {
        UserAccount plainUser = new UserAccount();
        plainUser.setUri(PLAIN_USER_URI);
        UserAccount rootUser = new UserAccount();
        rootUser.setUri(ROOT_USER_URI);
        rootUser.setRootUser(true);
        this.uaDao = new UserAccountsDaoStub();
        this.uaDao.addUser(plainUser);
        this.uaDao.addUser(rootUser);
        this.wdf = new WebappDaoFactoryStub();
        this.wdf.setUserAccountsDao(this.uaDao);
        this.ctx = new ServletContextStub();
        new ModelAccessFactoryStub().get(this.ctx).setWebappDaoFactory(this.wdf);
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(this.session);
        this.factory = new IsRootUserFactory((ServletContext)this.ctx);
    }

    @Test
    public void notLoggedIn() {
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[0]);
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        Assert.assertEquals((String)"empty bundle", (Object)this.expectedIds, (Object)this.actualIds);
    }

    @Test
    public void loggedInNotRoot() {
        LoginStatusBean lsb = new LoginStatusBean(PLAIN_USER_URI, LoginStatusBean.AuthenticationSource.EXTERNAL);
        LoginStatusBean.setBean((HttpSession)this.session, (LoginStatusBean)lsb);
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[0]);
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        Assert.assertEquals((String)"not root", (Object)this.expectedIds, (Object)this.actualIds);
    }

    @Test
    public void loggedInAsRoot() {
        LoginStatusBean lsb = new LoginStatusBean(ROOT_USER_URI, LoginStatusBean.AuthenticationSource.EXTERNAL);
        LoginStatusBean.setBean((HttpSession)this.session, (LoginStatusBean)lsb);
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[]{IsRootUser.INSTANCE});
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        Assert.assertEquals((String)"root", (Object)this.expectedIds, (Object)this.actualIds);
    }
}

